/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.regex.Pattern;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class StringSchema
extends Schema {
    private final Integer minLength;
    private final Integer maxLength;
    private final Pattern pattern;
    private final boolean requiresString;

    public static Builder builder() {
        return new Builder();
    }

    public StringSchema() {
        this(StringSchema.builder());
    }

    public StringSchema(Builder builder) {
        super(builder);
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.requiresString = builder.requiresString;
        this.pattern = builder.pattern != null ? Pattern.compile(builder.pattern) : null;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private void testLength(String subject) {
        int actualLength = subject.length();
        if (this.minLength != null && actualLength < this.minLength) {
            throw new ValidationException("expected minLength: " + this.minLength + ", actual: " + actualLength);
        }
        if (this.maxLength != null && actualLength > this.maxLength) {
            throw new ValidationException("expected maxLength: " + this.maxLength + ", actual: " + actualLength);
        }
    }

    private void testPattern(String subject) {
        if (this.pattern != null && !this.pattern.matcher(subject).find()) {
            throw new ValidationException(String.format("string [%s] does not match pattern %s", subject, this.pattern.pattern()));
        }
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof String)) {
            if (this.requiresString) {
                throw new ValidationException(String.class, subject);
            }
        } else {
            String stringSubject = (String)subject;
            this.testLength(stringSubject);
            this.testPattern(stringSubject);
        }
    }

    public static class Builder
    extends Schema.Builder<StringSchema> {
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private boolean requiresString = true;

        @Override
        public StringSchema build() {
            return new StringSchema(this);
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder requiresString(boolean requiresString) {
            this.requiresString = requiresString;
            return this;
        }
    }
}

