/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicRequestLine;
import org.esigate.api.ContainerRequestContext;
import org.esigate.api.Session;
import org.esigate.http.IncomingRequest;
import org.esigate.servlet.HttpServletRequestContext;
import org.esigate.servlet.impl.HttpServletSession;
import org.esigate.util.UriUtils;

public class RequestFactory {
    private final ServletContext servletContext;

    public RequestFactory(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public IncomingRequest create(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException {
        HttpServletRequestContext context = new HttpServletRequestContext(request, response, this.servletContext, filterChain);
        String uri = UriUtils.createURI((String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort(), (String)request.getRequestURI(), (String)request.getQueryString(), null);
        ProtocolVersion protocolVersion = BasicLineParser.parseProtocolVersion((String)request.getProtocol(), null);
        IncomingRequest.Builder builder = IncomingRequest.builder((RequestLine)new BasicRequestLine(request.getMethod(), uri, protocolVersion));
        builder.setContext((ContainerRequestContext)context);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                builder.addHeader(name, value);
            }
        }
        ServletInputStream inputStream = request.getInputStream();
        if (inputStream != null) {
            String contentEncodingHeader;
            String contentLengthHeader = request.getHeader("Content-Length");
            long contentLength = contentLengthHeader != null ? Long.parseLong(contentLengthHeader) : -1L;
            InputStreamEntity entity = new InputStreamEntity((InputStream)inputStream, contentLength);
            String contentTypeHeader = request.getContentType();
            if (contentTypeHeader != null) {
                entity.setContentType(contentTypeHeader);
            }
            if ((contentEncodingHeader = request.getCharacterEncoding()) != null) {
                entity.setContentEncoding(contentEncodingHeader);
            }
            builder.setEntity(entity);
        }
        builder.setRemoteAddr(request.getRemoteAddr());
        builder.setRemoteUser(request.getRemoteUser());
        HttpSession session = request.getSession(false);
        if (session != null) {
            builder.setSessionId(session.getId());
        }
        builder.setUserPrincipal(request.getUserPrincipal());
        javax.servlet.http.Cookie[] src = request.getCookies();
        if (src != null) {
            for (int i = 0; i < src.length; ++i) {
                javax.servlet.http.Cookie c = src[i];
                BasicClientCookie dest = new BasicClientCookie(c.getName(), c.getValue());
                dest.setSecure(c.getSecure());
                dest.setDomain(c.getDomain());
                dest.setPath(c.getPath());
                dest.setComment(c.getComment());
                dest.setVersion(c.getVersion());
                builder.addCookie((Cookie)dest);
            }
        }
        builder.setSession((Session)new HttpServletSession(request));
        return builder.build();
    }
}

