/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.cookie.Cookie;
import org.esigate.http.IncomingRequest;

public class ResponseSender {
    public javax.servlet.http.Cookie rewriteCookie(Cookie src) {
        javax.servlet.http.Cookie servletCookie = new javax.servlet.http.Cookie(src.getName(), src.getValue());
        if (src.getDomain() != null) {
            servletCookie.setDomain(src.getDomain());
        }
        servletCookie.setPath(src.getPath());
        servletCookie.setSecure(src.isSecure());
        servletCookie.setComment(src.getComment());
        servletCookie.setVersion(src.getVersion());
        if (src.getExpiryDate() != null) {
            int maxAge = (int)((src.getExpiryDate().getTime() - System.currentTimeMillis()) / 1000L);
            if (maxAge < 0) {
                maxAge = 0;
            }
            servletCookie.setMaxAge(maxAge);
        }
        return servletCookie;
    }

    public void sendResponse(HttpResponse httpResponse, IncomingRequest httpRequest, HttpServletResponse response) throws IOException {
        response.setStatus(httpResponse.getStatusLine().getStatusCode());
        for (Header header : httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            response.addHeader(name, value);
        }
        Cookie[] newCookies = httpRequest.getNewCookies();
        for (int i = 0; i < newCookies.length; ++i) {
            response.addCookie(this.rewriteCookie(newCookies[i]));
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            Header contentEncoding;
            Header contentType;
            long contentLength = httpEntity.getContentLength();
            if (contentLength > -1L && contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            }
            if ((contentType = httpEntity.getContentType()) != null) {
                response.setContentType(contentType.getValue());
            }
            if ((contentEncoding = httpEntity.getContentEncoding()) != null) {
                response.setHeader(contentEncoding.getName(), contentEncoding.getValue());
            }
            httpEntity.writeTo((OutputStream)response.getOutputStream());
        } else {
            response.sendError(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase());
        }
    }
}

