/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.api.ContainerRequestContext;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.extension.Extension;
import org.esigate.http.OutgoingRequest;
import org.esigate.http.OutgoingRequestContext;
import org.esigate.servlet.HttpServletRequestContext;
import org.esigate.servlet.impl.ResponseCapturingWrapper;
import org.esigate.util.UriUtils;

public class ServletExtension
implements Extension,
IEventListener {
    private Driver driver;
    private String context;
    private int maxObjectSize;

    public void init(Driver driver, Properties properties) {
        this.driver = driver;
        driver.getEventManager().register(EventManager.EVENT_FETCH_PRE, (IEventListener)this);
        this.context = properties.getProperty("context");
        this.maxObjectSize = Parameters.MAX_OBJECT_SIZE.getValueInt(properties);
    }

    public boolean event(EventDefinition id, Event event) {
        FetchEvent fetchEvent = (FetchEvent)event;
        if (EventManager.EVENT_FETCH_PRE.equals(id)) {
            CloseableHttpResponse result;
            ContainerRequestContext requestContext;
            String uriString = fetchEvent.getHttpRequest().getRequestLine().getUri();
            OutgoingRequest outgoingRequest = OutgoingRequestContext.adapt((HttpContext)fetchEvent.getHttpContext()).getOutgoingRequest();
            String baseUrl = outgoingRequest.getBaseUrl().toString();
            if (outgoingRequest.getOriginalRequest().isExternal()) {
                return true;
            }
            String relUrl = uriString;
            if (UriUtils.isAbsolute((String)relUrl)) {
                relUrl = relUrl.substring(UriUtils.extractHost((String)relUrl).toURI().length());
            }
            if (!(relUrl = relUrl.substring(UriUtils.getPath((String)baseUrl).length())).startsWith("/")) {
                relUrl = "/" + relUrl;
            }
            if (!((requestContext = outgoingRequest.getContainerRequestContext()) instanceof HttpServletRequestContext)) {
                String message = ServletExtension.class.getName() + " can be used only inside a java servlet engine";
                result = HttpErrorPage.generateHttpResponse((int)502, (String)message);
            } else {
                HttpServletRequestContext httpServletRequestContext = (HttpServletRequestContext)requestContext;
                try {
                    if (fetchEvent.getHttpContext().isProxy()) {
                        ResponseCapturingWrapper wrappedResponse = new ResponseCapturingWrapper(httpServletRequestContext.getResponse(), this.driver.getContentTypeHelper(), true, this.maxObjectSize);
                        if (this.context == null) {
                            httpServletRequestContext.getFilterChain().doFilter((ServletRequest)httpServletRequestContext.getRequest(), (ServletResponse)wrappedResponse);
                            result = wrappedResponse.getResponse();
                        } else {
                            ServletContext crossContext = httpServletRequestContext.getServletContext().getContext(this.context);
                            if (crossContext == null) {
                                String message = "Context " + this.context + " does not exist or cross context disabled";
                                result = HttpErrorPage.generateHttpResponse((int)502, (String)message);
                            } else {
                                crossContext.getRequestDispatcher(relUrl).forward((ServletRequest)httpServletRequestContext.getRequest(), (ServletResponse)wrappedResponse);
                                result = wrappedResponse.getResponse();
                            }
                        }
                    } else {
                        ResponseCapturingWrapper wrappedResponse = new ResponseCapturingWrapper(httpServletRequestContext.getResponse(), this.driver.getContentTypeHelper(), false, this.maxObjectSize);
                        if (this.context == null) {
                            httpServletRequestContext.getRequest().getRequestDispatcher(relUrl).forward((ServletRequest)httpServletRequestContext.getRequest(), (ServletResponse)wrappedResponse);
                            result = wrappedResponse.getResponse();
                        } else {
                            ServletContext crossContext = httpServletRequestContext.getServletContext().getContext(this.context);
                            if (crossContext == null) {
                                String message = "Context " + this.context + " does not exist or cross context disabled";
                                result = HttpErrorPage.generateHttpResponse((int)502, (String)message);
                            } else {
                                crossContext.getRequestDispatcher(relUrl).include((ServletRequest)httpServletRequestContext.getRequest(), (ServletResponse)wrappedResponse);
                                result = wrappedResponse.getResponse();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    result = HttpErrorPage.generateHttpResponse((Exception)e);
                }
                catch (ServletException e) {
                    result = HttpErrorPage.generateHttpResponse((Exception)((Object)e));
                }
            }
            fetchEvent.setHttpResponse(result);
            fetchEvent.setExit(true);
        }
        return true;
    }
}

