/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.esigate.HttpErrorPage;
import org.esigate.test.conn.IResponseHandler;
import org.esigate.test.conn.IResponseHandler2;

public class MockConnectionManager
implements HttpClientConnectionManager {
    private final AtomicInteger openConnections = new AtomicInteger(0);
    private IResponseHandler responseHandler;
    private HttpRequest lastSentRequest;
    private long sleep = 0L;

    private void sleep() {
        if (this.sleep > 0L) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        return new ConnectionRequest(){

            public boolean cancel() {
                return false;
            }

            public HttpClientConnection get(long timeout, TimeUnit tunit) {
                MockConnectionManager.this.openConnections.incrementAndGet();
                return new HttpClientConnection(){
                    private boolean open = true;
                    private HttpRequest request;

                    public void shutdown() {
                        this.close();
                    }

                    public void setSocketTimeout(int timeout) {
                    }

                    public boolean isStale() {
                        return !this.open;
                    }

                    public boolean isOpen() {
                        return this.open;
                    }

                    public int getSocketTimeout() {
                        return 0;
                    }

                    public HttpConnectionMetrics getMetrics() {
                        return null;
                    }

                    public void close() {
                        MockConnectionManager.this.openConnections.decrementAndGet();
                        this.open = false;
                    }

                    public void sendRequestHeader(HttpRequest request) {
                        MockConnectionManager.this.lastSentRequest = request;
                        this.request = request;
                    }

                    public void sendRequestEntity(HttpEntityEnclosingRequest request) {
                        MockConnectionManager.this.lastSentRequest = (HttpRequest)request;
                        this.request = request;
                    }

                    public HttpResponse receiveResponseHeader() {
                        MockConnectionManager.this.sleep();
                        return MockConnectionManager.this.execute(this.request);
                    }

                    public void receiveResponseEntity(HttpResponse response) {
                    }

                    public boolean isResponseAvailable(int timeout) {
                        return true;
                    }

                    public void flush() {
                    }
                };
            }
        };
    }

    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        try {
            conn.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeIdleConnections(long idletime, TimeUnit tunit) {
    }

    public void closeExpiredConnections() {
    }

    public void shutdown() {
        if (this.openConnections.get() > 0) {
            throw new RuntimeException("Some connections were not released!");
        }
    }

    public HttpRequest getSentRequest() {
        return this.lastSentRequest;
    }

    public void setResponse(final HttpResponse response) {
        this.setResponseHandler(new IResponseHandler(){

            @Override
            public HttpResponse execute(HttpRequest request) {
                return response;
            }
        });
    }

    public void setResponseHandler(IResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public HttpResponse execute(HttpRequest request) {
        try {
            return this.responseHandler.execute(request);
        }
        catch (IOException e) {
            return HttpErrorPage.generateHttpResponse(e);
        }
    }

    public final boolean hasOpenConnections() {
        return this.openConnections.get() > 0;
    }

    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) {
        if (this.responseHandler instanceof IResponseHandler2) {
            ((IResponseHandler2)this.responseHandler).connect(conn, route, connectTimeout, context);
        }
    }

    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) {
    }

    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) {
    }
}

