/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.esigate.HttpErrorPage;
import org.esigate.impl.DriverRequest;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContextImpl;
import org.esigate.parser.UnknownElementType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    private final Pattern pattern;
    private final List<ElementType> elementTypes;
    private DriverRequest httpRequest;
    private HttpResponse httpResponse;

    public Parser(Pattern pattern, ElementType ... elementTypes) {
        this.pattern = pattern;
        this.elementTypes = new ArrayList<ElementType>(elementTypes.length + 1);
        Collections.addAll(this.elementTypes, elementTypes);
        this.elementTypes.add(new UnknownElementType());
    }

    public void parse(CharSequence in, Appendable out) throws IOException, HttpErrorPage {
        ParserContextImpl ctx = new ParserContextImpl(out, this.httpRequest, this.httpResponse);
        Matcher matcher = this.pattern.matcher(in);
        int currentPosition = 0;
        while (matcher.find()) {
            String tag = matcher.group();
            ctx.characters(in, currentPosition, matcher.start());
            currentPosition = matcher.end();
            if (ctx.isCurrentTagEnd(tag)) {
                LOG.info("Processing end tag {}", (Object)tag);
                ctx.endElement(tag);
                continue;
            }
            LOG.info("Processing start tag {}", (Object)tag);
            ElementType type = null;
            for (ElementType t : this.elementTypes) {
                if (!t.isStartTag(tag)) continue;
                type = t;
                break;
            }
            Element element = type.newInstance();
            ctx.startElement(type, element, tag);
            if (!type.isSelfClosing(tag)) continue;
            ctx.endElement(tag);
        }
        ctx.characters(in, currentPosition, in.length());
    }

    public void setHttpRequest(DriverRequest httpRequest) {
        this.httpRequest = httpRequest;
    }
}

