/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.esigate.Driver;
import org.esigate.impl.UriMapping;
import org.esigate.impl.UriMappingComparator;

public class IndexedInstances {
    private final Map<String, Driver> instances;
    private final Map<UriMapping, String> uriMappings;

    public IndexedInstances(Map<String, Driver> instances) {
        this.instances = instances;
        this.uriMappings = this.buildUriMappings();
    }

    private Map<UriMapping, String> buildUriMappings() {
        LinkedHashMap<UriMapping, String> result = new LinkedHashMap<UriMapping, String>();
        LinkedHashMap<UriMapping, String> unsortedResult = new LinkedHashMap<UriMapping, String>();
        if (this.instances != null) {
            for (String instanceId : this.instances.keySet()) {
                List<UriMapping> driverMappings = this.instances.get(instanceId).getConfiguration().getUriMappings();
                for (UriMapping mapping : driverMappings) {
                    unsortedResult.put(mapping, instanceId);
                }
            }
        }
        TreeSet<UriMapping> keys = new TreeSet<UriMapping>(new UriMappingComparator());
        keys.addAll(unsortedResult.keySet());
        for (UriMapping key : keys) {
            result.put(key, (String)unsortedResult.get(key));
        }
        return result;
    }

    public Map<String, Driver> getInstances() {
        return this.instances;
    }

    public Map<UriMapping, String> getUrimappings() {
        return this.uriMappings;
    }
}

