/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.IEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    public static final EventDefinition EVENT_FRAGMENT_PRE = new EventDefinition("org.esigate.fragment-pre", 1);
    public static final EventDefinition EVENT_FRAGMENT_POST = new EventDefinition("org.esigate.fragment-post", 2);
    public static final EventDefinition EVENT_FETCH_PRE = new EventDefinition("org.esigate.fetch-pre", 1);
    public static final EventDefinition EVENT_FETCH_POST = new EventDefinition("org.esigate.fetch-post", 2);
    public static final EventDefinition EVENT_PROXY_PRE = new EventDefinition("org.esigate.proxy-pre", 1);
    public static final EventDefinition EVENT_PROXY_POST = new EventDefinition("org.esigate.proxy-post", 2);
    public static final EventDefinition EVENT_RENDER_PRE = new EventDefinition("org.esigate.render-pre", 1);
    public static final EventDefinition EVENT_RENDER_POST = new EventDefinition("org.esigate.render-post", 2);
    public static final EventDefinition EVENT_READ_ENTITY = new EventDefinition("org.esigate.readEntity.", 1);
    public static final EventDefinition EVENT_HTTP_BUILDER_INITIALIZATION = new EventDefinition("org.esigate.httpBuilderInitialization.", 2);
    private static final Logger LOG = LoggerFactory.getLogger(EventManager.class);
    private final String driverId;
    private Map<EventDefinition, List<IEventListener>> listeners = new HashMap<EventDefinition, List<IEventListener>>();
    private Map<EventDefinition, List<IEventListener>> listenersPost = new HashMap<EventDefinition, List<IEventListener>>();

    public EventManager(String driverId) {
        this.driverId = driverId;
    }

    private void register(Map<EventDefinition, List<IEventListener>> listenerMappings, EventDefinition eventDefinition, IEventListener listener, boolean reverseOrder) {
        List<IEventListener> eventListeners = listenerMappings.get(eventDefinition);
        if (eventListeners == null) {
            eventListeners = new ArrayList<IEventListener>();
            listenerMappings.put(eventDefinition, eventListeners);
        }
        if (!eventListeners.contains(listener)) {
            if (reverseOrder) {
                eventListeners.add(eventListeners.size(), listener);
            } else {
                eventListeners.add(listener);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Registered {} on event {}/{}", new Object[]{listener.getClass().getName(), this.driverId, eventDefinition});
            }
        }
    }

    public void register(EventDefinition eventDefinition, IEventListener listener) {
        if (eventDefinition.getType() == 2) {
            this.register(this.listenersPost, eventDefinition, listener, true);
        } else {
            this.register(this.listeners, eventDefinition, listener, false);
        }
    }

    public void fire(EventDefinition eventDefinition, Event eventDetails) {
        if (eventDefinition.getType() == 2) {
            this.fire(this.listenersPost, eventDefinition, eventDetails);
        } else {
            this.fire(this.listeners, eventDefinition, eventDetails);
        }
    }

    private void fire(Map<EventDefinition, List<IEventListener>> listenerMappings, EventDefinition eventDefinition, Event eventDetails) {
        List<IEventListener> eventListeners = listenerMappings.get(eventDefinition);
        if (eventListeners == null) {
            return;
        }
        for (IEventListener el : eventListeners) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running {} on event {}/{}", new Object[]{el, this.driverId, eventDefinition});
            }
            if (el.event(eventDefinition, eventDetails)) continue;
            return;
        }
    }

    public void unregister(EventDefinition eventDefinition, IEventListener eventListener) {
        if (eventDefinition.getType() == 2) {
            this.unregister(this.listenersPost, eventDefinition, eventListener);
        } else {
            this.unregister(this.listeners, eventDefinition, eventListener);
        }
    }

    private void unregister(Map<EventDefinition, List<IEventListener>> listenerMappings, EventDefinition eventDefinition, IEventListener listener) {
        List<IEventListener> eventListeners = listenerMappings.get(eventDefinition);
        if (eventListeners == null) {
            return;
        }
        boolean removed = eventListeners.remove(listener);
        if (LOG.isInfoEnabled() && removed) {
            LOG.info("Unregistered {} on event {}/{}", new Object[]{listener.getClass().getName(), this.driverId, eventDefinition});
        }
    }
}

