/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.aggregator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.AggregateRenderer;
import org.esigate.aggregator.ElementAttributes;
import org.esigate.aggregator.ElementAttributesFactory;
import org.esigate.http.HttpResponseUtils;
import org.esigate.parser.Adapter;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.tags.TemplateRenderer;

class IncludeTemplateElement
implements Element {
    public static final ElementType TYPE = new ElementType(){

        @Override
        public boolean isStartTag(String tag) {
            return tag.startsWith("<!--$includetemplate$");
        }

        @Override
        public boolean isEndTag(String tag) {
            return tag.startsWith("<!--$endincludetemplate$");
        }

        @Override
        public Element newInstance() {
            return new IncludeTemplateElement();
        }

        @Override
        public boolean isSelfClosing(String tag) {
            return false;
        }
    };
    private Driver driver;
    private String page;
    private String name;
    private final Map<String, String> params = new HashMap<String, String>();
    private Appendable out;

    IncludeTemplateElement() {
    }

    @Override
    public boolean onError(Exception e, ParserContext ctx) {
        return false;
    }

    @Override
    public boolean onTagStart(String tag, ParserContext ctx) {
        this.out = new Adapter(ctx.getCurrent());
        ElementAttributes tagAttributes = ElementAttributesFactory.createElementAttributes(tag);
        this.driver = tagAttributes.getDriver();
        this.page = tagAttributes.getPage();
        this.name = tagAttributes.getName();
        return true;
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        CloseableHttpResponse response = this.driver.render(this.page, ctx.getHttpRequest().getOriginalRequest(), new TemplateRenderer(this.name, this.params, this.page), new AggregateRenderer());
        this.out.append(HttpResponseUtils.toString(response));
    }

    public void addParam(String paramName, String value) {
        this.params.put(paramName, value);
    }

    @Override
    public void characters(CharSequence csq, int start, int end) {
    }
}

