/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.esigate.impl.DriverRequest;
import org.esigate.util.UriUtils;

public final class HttpRequestHelper {
    private HttpRequestHelper() {
    }

    public static String getFirstHeader(String name, HttpRequest request) {
        Header header = request.getFirstHeader(name);
        String headerValue = null;
        if (header != null) {
            headerValue = header.getValue();
        }
        return headerValue;
    }

    public static String getParameter(DriverRequest request, String name) {
        String characterEncoding = request.getCharacterEncoding();
        if (characterEncoding == null) {
            characterEncoding = "ISO-8859-1";
        }
        List<NameValuePair> parameters = UriUtils.parse(request.getOriginalRequest().getRequestLine().getUri(), characterEncoding);
        for (NameValuePair nameValuePair : parameters) {
            if (!nameValuePair.getName().equals(name)) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    public static HttpHost getHost(HttpRequest request) {
        HttpHost httpHost = UriUtils.extractHost(request.getRequestLine().getUri());
        String scheme = httpHost.getSchemeName();
        String host = httpHost.getHostName();
        int port = httpHost.getPort();
        Header[] headers = request.getHeaders("Host");
        if (headers != null && headers.length != 0) {
            String headerValue = headers[0].getValue();
            String[] splitted = headerValue.split(":");
            host = splitted[0];
            port = splitted.length > 1 ? Integer.parseInt(splitted[1]) : -1;
        }
        return new HttpHost(host, port, scheme);
    }
}

