/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.RequestExecutor;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.cookie.CookieManager;
import org.esigate.events.EventManager;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.events.impl.HttpClientBuilderEvent;
import org.esigate.extension.ExtensionFactory;
import org.esigate.http.BasicCloseableHttpResponse;
import org.esigate.http.ContentTypeHelper;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.IncomingRequest;
import org.esigate.http.OutgoingRequest;
import org.esigate.http.OutgoingRequestContext;
import org.esigate.http.ProxyingHttpClientBuilder;
import org.esigate.http.RequestCookieStore;
import org.esigate.http.UnsupportedHttpMethodException;
import org.esigate.http.cookie.CustomBrowserCompatSpecFactory;
import org.esigate.impl.DriverRequest;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientRequestExecutor
implements RequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientRequestExecutor.class);
    private static final Set<String> SIMPLE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE", "DELETE")));
    private static final Set<String> ENTITY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK")));
    private boolean preserveHost;
    private CookieManager cookieManager;
    private HttpClient httpClient;
    private EventManager eventManager = null;
    private int connectTimeout;
    private int socketTimeout;
    private HttpHost firstBaseUrlHost;

    public static HttpClientRequestExecutorBuilder builder() {
        return new HttpClientRequestExecutorBuilder();
    }

    private HttpClientRequestExecutor() {
    }

    @Override
    public OutgoingRequest createOutgoingRequest(DriverRequest originalRequest, String uri, boolean proxy) {
        HttpHost physicalHost = UriUtils.extractHost(uri);
        if (!originalRequest.isExternal()) {
            if (this.preserveHost) {
                HttpHost virtualHost = HttpRequestHelper.getHost((HttpRequest)originalRequest.getOriginalRequest());
                uri = UriUtils.rewriteURI(uri, virtualHost);
            } else {
                uri = UriUtils.rewriteURI(uri, this.firstBaseUrlHost);
            }
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(this.connectTimeout);
        builder.setSocketTimeout(this.socketTimeout);
        builder.setCookieSpec("custom_browser_compatibility");
        builder.setRedirectsEnabled(false);
        RequestConfig config = builder.build();
        OutgoingRequestContext context = new OutgoingRequestContext();
        String method = "GET";
        if (proxy) {
            method = originalRequest.getOriginalRequest().getRequestLine().getMethod().toUpperCase();
        }
        OutgoingRequest outgoingRequest = new OutgoingRequest(method, uri, originalRequest.getOriginalRequest().getProtocolVersion(), originalRequest, config, context);
        if (ENTITY_METHODS.contains(method)) {
            outgoingRequest.setEntity(originalRequest.getOriginalRequest().getEntity());
        } else if (!SIMPLE_METHODS.contains(method)) {
            throw new UnsupportedHttpMethodException(method + " " + uri);
        }
        context.setPhysicalHost(physicalHost);
        context.setOutgoingRequest(outgoingRequest);
        context.setProxy(proxy);
        return outgoingRequest;
    }

    @Override
    public CloseableHttpResponse execute(OutgoingRequest httpRequest) throws HttpErrorPage {
        CloseableHttpResponse httpResponse;
        OutgoingRequestContext context = httpRequest.getContext();
        IncomingRequest originalRequest = httpRequest.getOriginalRequest().getOriginalRequest();
        if (this.cookieManager != null) {
            RequestCookieStore cookieStore = new RequestCookieStore(this.cookieManager, httpRequest.getOriginalRequest());
            context.setCookieStore(cookieStore);
        }
        FragmentEvent event = new FragmentEvent(originalRequest, httpRequest, context);
        this.eventManager.fire(EventManager.EVENT_FRAGMENT_PRE, event);
        if (!event.isExit()) {
            if (event.getHttpResponse() == null) {
                if (httpRequest.containsHeader("Expect")) {
                    event.setHttpResponse(HttpErrorPage.generateHttpResponse(417, "'Expect' request header is not supported"));
                } else {
                    CloseableHttpResponse result;
                    try {
                        HttpHost physicalHost = context.getPhysicalHost();
                        result = this.httpClient.execute(physicalHost, (HttpRequest)httpRequest, (HttpContext)context);
                    }
                    catch (IOException e) {
                        result = HttpErrorPage.generateHttpResponse(e);
                        LOG.warn(httpRequest.getRequestLine() + " -> " + result.getStatusLine().toString());
                    }
                    event.setHttpResponse(BasicCloseableHttpResponse.adapt((HttpResponse)result));
                }
            }
            this.eventManager.fire(EventManager.EVENT_FRAGMENT_POST, event);
        }
        if ((httpResponse = event.getHttpResponse()) == null) {
            throw new HttpErrorPage(500, "Request was cancelled by server", "Request was cancelled by server");
        }
        if (HttpResponseUtils.isError((HttpResponse)httpResponse)) {
            throw new HttpErrorPage(httpResponse);
        }
        return httpResponse;
    }

    public static final class HttpClientRequestExecutorBuilder
    implements RequestExecutor.RequestExecutorBuilder {
        private EventManager eventManager;
        private Properties properties;
        private Driver driver;
        private HttpClientConnectionManager connectionManager;
        private CookieManager cookieManager;

        @Override
        public HttpClientRequestExecutorBuilder setDriver(Driver pDriver) {
            this.driver = pDriver;
            return this;
        }

        @Override
        public HttpClientRequestExecutorBuilder setProperties(Properties pProperties) {
            this.properties = pProperties;
            return this;
        }

        @Override
        public HttpClientRequestExecutor build() {
            if (this.eventManager == null) {
                throw new ConfigurationException("eventManager is mandatory");
            }
            if (this.driver == null) {
                throw new ConfigurationException("driver is mandatory");
            }
            if (this.properties == null) {
                throw new ConfigurationException("properties is mandatory");
            }
            HttpClientRequestExecutor result = new HttpClientRequestExecutor();
            result.eventManager = this.eventManager;
            result.preserveHost = Parameters.PRESERVE_HOST.getValue(this.properties);
            if (this.cookieManager == null) {
                this.cookieManager = (CookieManager)ExtensionFactory.getExtension(this.properties, Parameters.COOKIE_MANAGER, this.driver);
            }
            result.cookieManager = this.cookieManager;
            result.connectTimeout = Parameters.CONNECT_TIMEOUT.getValue(this.properties);
            result.socketTimeout = Parameters.SOCKET_TIMEOUT.getValue(this.properties);
            result.httpClient = this.buildHttpClient();
            String firstBaseURL = Parameters.REMOTE_URL_BASE.getValue(this.properties)[0];
            result.firstBaseUrlHost = UriUtils.extractHost(firstBaseURL);
            return result;
        }

        @Override
        public HttpClientRequestExecutorBuilder setContentTypeHelper(ContentTypeHelper contentTypeHelper) {
            return this;
        }

        public HttpClientRequestExecutorBuilder setConnectionManager(HttpClientConnectionManager pConnectionManager) {
            this.connectionManager = pConnectionManager;
            return this;
        }

        @Override
        public HttpClientRequestExecutorBuilder setEventManager(EventManager pEventManager) {
            this.eventManager = pEventManager;
            return this;
        }

        public HttpClientRequestExecutorBuilder setCookieManager(CookieManager pCookieManager) {
            this.cookieManager = pCookieManager;
            return this;
        }

        private HttpClient buildHttpClient() {
            HttpHost proxyHost = null;
            UsernamePasswordCredentials proxyCredentials = null;
            String proxyHostParameter = Parameters.PROXY_HOST.getValue(this.properties);
            if (proxyHostParameter != null) {
                int proxyPort = Parameters.PROXY_PORT.getValue(this.properties);
                proxyHost = new HttpHost(proxyHostParameter, proxyPort);
                String proxyUser = Parameters.PROXY_USER.getValue(this.properties);
                if (proxyUser != null) {
                    String proxyPassword = Parameters.PROXY_PASSWORD.getValue(this.properties);
                    proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                }
            }
            ProxyingHttpClientBuilder httpClientBuilder = new ProxyingHttpClientBuilder();
            httpClientBuilder.disableContentCompression();
            httpClientBuilder.setProperties(this.properties);
            httpClientBuilder.setMaxConnPerRoute(Parameters.MAX_CONNECTIONS_PER_HOST.getValue(this.properties));
            httpClientBuilder.setMaxConnTotal(Parameters.MAX_CONNECTIONS_PER_HOST.getValue(this.properties));
            if (proxyHost != null) {
                httpClientBuilder.setProxy(proxyHost);
                if (proxyCredentials != null) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)proxyCredentials);
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
            }
            boolean useCache = Parameters.USE_CACHE.getValue(this.properties);
            httpClientBuilder.setUseCache(Parameters.USE_CACHE.getValue(this.properties));
            if (useCache) {
                httpClientBuilder.setHttpCacheStorage(CacheConfigHelper.createCacheStorage(this.properties));
                httpClientBuilder.setCacheConfig(CacheConfigHelper.createCacheConfig(this.properties));
            }
            httpClientBuilder.setEventManager(this.eventManager);
            if (this.connectionManager != null) {
                httpClientBuilder.setConnectionManager(this.connectionManager);
            }
            Registry cookieSpecRegistry = RegistryBuilder.create().register("custom_browser_compatibility", (Object)new CustomBrowserCompatSpecFactory()).build();
            RequestConfig config = RequestConfig.custom().setCookieSpec("custom_browser_compatibility").build();
            httpClientBuilder.setDefaultCookieSpecRegistry((Lookup)cookieSpecRegistry).setDefaultRequestConfig(config);
            this.driver.getEventManager().fire(EventManager.EVENT_HTTP_BUILDER_INITIALIZATION, new HttpClientBuilderEvent((HttpClientBuilder)httpClientBuilder));
            return httpClientBuilder.build();
        }
    }
}

