/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.parallelesi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.extension.parallelesi.BaseElement;
import org.esigate.extension.parallelesi.BaseElementType;
import org.esigate.extension.parallelesi.EsiRenderer;
import org.esigate.extension.parallelesi.InlineCache;
import org.esigate.extension.parallelesi.Tag;
import org.esigate.http.HttpResponseUtils;
import org.esigate.impl.DriverRequest;
import org.esigate.parser.future.CharSequenceFuture;
import org.esigate.parser.future.FutureElement;
import org.esigate.parser.future.FutureElementType;
import org.esigate.parser.future.FutureParserContext;
import org.esigate.parser.future.StringBuilderFutureAppendable;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IncludeElement
extends BaseElement {
    private static final String PROVIDER_PATTERN = "$(PROVIDER{";
    private static final String LEGACY_PROVIDER_PATTERN = "$PROVIDER({";
    private static final Logger LOG = LoggerFactory.getLogger(IncludeElement.class);
    public static final FutureElementType TYPE = new BaseElementType("<esi:include", "</esi:include"){

        @Override
        public IncludeElement newInstance() {
            return new IncludeElement();
        }
    };
    private StringBuilderFutureAppendable buf;
    private Map<String, CharSequence> fragmentReplacements;
    private Map<String, CharSequence> regexpReplacements;
    private Tag includeTag;
    private boolean write = false;

    IncludeElement() {
    }

    @Override
    public void characters(Future<CharSequence> csq) {
        if (this.write) {
            this.buf.enqueueAppend(csq);
        }
    }

    @Override
    public void onTagEnd(String tag, FutureParserContext ctx) throws IOException, HttpErrorPage {
        Future<CharSequence> result;
        this.write = true;
        String src = this.includeTag.getAttribute("src");
        String alt = this.includeTag.getAttribute("alt");
        boolean ignoreError = "continue".equals(this.includeTag.getAttribute("onerror"));
        FutureElement current = ctx.getCurrent();
        Executor executor = (Executor)ctx.getData("executor");
        IncludeTask task = new IncludeTask(this.includeTag, src, alt, ctx, current, ignoreError, this.fragmentReplacements, this.regexpReplacements, executor);
        if (executor == null) {
            CharSequence content = task.call();
            result = new CharSequenceFuture(content);
        } else {
            FutureTask<CharSequence> r = new FutureTask<CharSequence>(task);
            executor.execute(r);
            result = r;
        }
        ctx.getCurrent().characters(result);
    }

    @Override
    protected boolean parseTag(Tag tag, FutureParserContext ctx) {
        this.buf = new StringBuilderFutureAppendable();
        this.fragmentReplacements = new HashMap<String, CharSequence>();
        this.regexpReplacements = new HashMap<String, CharSequence>();
        this.includeTag = tag;
        return true;
    }

    void addFragmentReplacement(String fragment, CharSequence replacement) {
        this.fragmentReplacements.put(fragment, replacement);
    }

    void addRegexpReplacement(String regexp, CharSequence replacement) {
        this.regexpReplacements.put(regexp, replacement);
    }

    private static final class IncludeTask
    implements Callable<CharSequence> {
        private String src;
        private String alt;
        private FutureParserContext ctx;
        private boolean ignoreError;
        private FutureElement current;
        private Tag includeTag;
        private Map<String, CharSequence> fragmentReplacements;
        private Map<String, CharSequence> regexpReplacements;
        private Executor executor;

        private IncludeTask(Tag includeTag, String src, String alt, FutureParserContext ctx, FutureElement current, boolean ignoreError, Map<String, CharSequence> fragmentReplacements, Map<String, CharSequence> regexpReplacements, Executor executor) {
            this.src = src;
            this.alt = alt;
            this.ctx = ctx;
            this.ignoreError = ignoreError;
            this.current = current;
            this.includeTag = includeTag;
            this.fragmentReplacements = fragmentReplacements;
            this.regexpReplacements = regexpReplacements;
            this.executor = executor;
        }

        @Override
        public CharSequence call() throws IOException, HttpErrorPage {
            LOG.debug("Starting include task {}", (Object)this.src);
            StringBuilderWriter sw = new StringBuilderWriter(1024);
            Exception currentException = null;
            try {
                this.processPage(this.src, this.includeTag, (Appendable)sw);
            }
            catch (IOException | HttpErrorPage e) {
                currentException = e;
            }
            if (currentException != null && this.alt != null) {
                currentException = null;
                try {
                    this.processPage(this.alt, this.includeTag, (Appendable)sw);
                }
                catch (IOException | HttpErrorPage e) {
                    currentException = e;
                }
            }
            if (currentException != null && !this.ignoreError && !this.ctx.reportError(this.current, currentException)) {
                if (currentException instanceof IOException) {
                    throw (IOException)currentException;
                }
                throw (HttpErrorPage)currentException;
            }
            String result = sw.toString();
            if (!this.regexpReplacements.isEmpty()) {
                for (Map.Entry<String, CharSequence> entry : this.regexpReplacements.entrySet()) {
                    result = Pattern.compile(entry.getKey()).matcher(result).replaceAll(entry.getValue().toString());
                }
            }
            return result;
        }

        private void processPage(String srcOrAlt, Tag tag, Appendable out) throws IOException, HttpErrorPage {
            String provider;
            int endIndex;
            int startIdx;
            Driver driver;
            String page;
            String fragment = tag.getAttribute("fragment");
            String xpath = tag.getAttribute("xpath");
            String xslt = tag.getAttribute("stylesheet");
            DriverRequest httpRequest = this.ctx.getHttpRequest();
            ArrayList<Renderer> rendererList = new ArrayList<Renderer>();
            int idx = srcOrAlt.indexOf(IncludeElement.PROVIDER_PATTERN);
            int idxLegacyPattern = srcOrAlt.indexOf(IncludeElement.LEGACY_PROVIDER_PATTERN);
            if (idx < 0 && idxLegacyPattern < 0) {
                page = srcOrAlt;
                driver = httpRequest.getDriver();
            } else if (idx >= 0) {
                startIdx = idx + IncludeElement.PROVIDER_PATTERN.length();
                endIndex = srcOrAlt.indexOf("})", startIdx);
                provider = srcOrAlt.substring(startIdx, endIndex);
                page = srcOrAlt.substring(endIndex + "})".length());
                driver = DriverFactory.getInstance(provider);
                if (LOG.isWarnEnabled() && idx > 0) {
                    LOG.warn("Invalid src attribute : [{}], src should start with [{}{}})]. First characters [{}] have been ignored", new Object[]{srcOrAlt, IncludeElement.PROVIDER_PATTERN, provider, srcOrAlt.substring(0, idx)});
                }
            } else {
                startIdx = idxLegacyPattern + IncludeElement.PROVIDER_PATTERN.length();
                endIndex = srcOrAlt.indexOf("})", startIdx);
                provider = srcOrAlt.substring(startIdx, endIndex);
                page = srcOrAlt.substring(endIndex + "})".length());
                driver = DriverFactory.getInstance(provider);
                if (LOG.isWarnEnabled() && idxLegacyPattern > 0) {
                    LOG.warn("Invalid src attribute : [{}], src should start with [{}{}})]. First characters [{}] have been ignored", new Object[]{srcOrAlt, IncludeElement.PROVIDER_PATTERN, provider, srcOrAlt.substring(0, idxLegacyPattern)});
                }
            }
            InlineCache ic = InlineCache.getFragment(srcOrAlt);
            if (ic != null && !ic.isExpired()) {
                String cache = ic.getFragment();
                out.append(cache);
            } else {
                EsiRenderer esiRenderer = fragment != null ? new EsiRenderer(page, fragment, this.executor) : new EsiRenderer(this.executor);
                if (this.fragmentReplacements != null && !this.fragmentReplacements.isEmpty()) {
                    esiRenderer.setFragmentsToReplace(this.fragmentReplacements);
                }
                rendererList.add(esiRenderer);
                if (xpath != null) {
                    rendererList.add(new XpathRenderer(xpath));
                } else if (xslt != null) {
                    rendererList.add(new XsltRenderer(xslt, driver, httpRequest));
                }
                CloseableHttpResponse response = driver.render(page, httpRequest.getOriginalRequest(), rendererList.toArray(new Renderer[rendererList.size()]));
                out.append(HttpResponseUtils.toString(response));
            }
        }
    }
}

