/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.ReadEntityEvent;
import org.esigate.extension.DefaultCharset;
import org.esigate.extension.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlCharsetProcessor
implements Extension,
IEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCharset.class);
    private static final Pattern PATTERN_META_HTML5 = Pattern.compile(".*<head>.*<meta[^>]+charset=\"([^>^\"]+)\"[^>]*/?>.*</head>.*", 2);
    private static final Pattern PATTERN_META_HTML4_XHTML = Pattern.compile(".*<head>.*<meta[^>]+charset=([^>^\"]+)\"[^>]*/?>.*</head>.*", 2);

    @Override
    public boolean event(EventDefinition id, Event event) {
        ReadEntityEvent readEntityEvent = (ReadEntityEvent)event;
        Charset charset = null;
        LOG.debug("Content mime type is {}", (Object)readEntityEvent.getMimeType());
        if ("text/html".equals(readEntityEvent.getMimeType()) || "application/xhtml+xml".equals(readEntityEvent.getMimeType())) {
            LOG.debug("Supported MIME type, parsing content");
            Matcher m = PATTERN_META_HTML5.matcher(readEntityEvent.getEntityContent());
            if (m.matches()) {
                LOG.debug("Found HTML5 charset");
                charset = Charset.forName(m.group(1));
            }
            if ((m = PATTERN_META_HTML4_XHTML.matcher(readEntityEvent.getEntityContent())).matches()) {
                LOG.debug("Found HTML/XHTML charset");
                charset = Charset.forName(m.group(1));
            }
        }
        if (charset != null && !charset.equals(readEntityEvent.getCharset())) {
            LOG.debug("Changing charset fom {} to {}", (Object)readEntityEvent.getCharset(), (Object)charset);
            readEntityEvent.setEntityContent(new String(readEntityEvent.getRawEntityContent(), charset));
        }
        return true;
    }

    @Override
    public void init(Driver driver, Properties properties) {
        driver.getEventManager().register(EventManager.EVENT_READ_ENTITY, this);
    }
}

