/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;

public final class UriUtils {
    private static final int CONVERSION_TABLE_SIZE = 128;
    private static final String RESERVED_CHARACTERS = ":/?&=#%";
    private static final String[] CONVERSION_TABLE = new String[128];

    private UriUtils() {
    }

    private static String encode(char character) {
        return Character.toString(character);
    }

    private static String encode(String charString) {
        try {
            return new URI(null, null, null, -1, charString, null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static String encodeIllegalCharacters(String uri) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < uri.length(); ++i) {
            char character = uri.charAt(i);
            char j = character;
            if (j >= '\u0080' || j < '\u0000') {
                result.append(UriUtils.encode(character));
                continue;
            }
            result.append(CONVERSION_TABLE[j]);
        }
        return result.toString();
    }

    public static String createURI(String scheme, String host, int port, String path, String query, String fragment) {
        StringBuilder buffer = new StringBuilder(256);
        if (host != null) {
            if (scheme != null) {
                buffer.append(scheme);
                buffer.append("://");
            }
            buffer.append(host);
            if (port > 0) {
                buffer.append(':');
                buffer.append(port);
            }
        }
        if (path == null || !path.startsWith("/")) {
            buffer.append('/');
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return buffer.toString();
    }

    public static String extractHostName(String uri) {
        return UriUtils.extractHost(uri).getHostName();
    }

    public static HttpHost extractHost(String uri) {
        return URIUtils.extractHost((URI)UriUtils.createURI(uri));
    }

    public static HttpHost extractHost(URI uri) {
        return URIUtils.extractHost((URI)uri);
    }

    public static URI createURI(String uri) {
        URI result = URI.create(uri = UriUtils.encodeIllegalCharacters(uri));
        if (result.getHost() != null && StringUtils.isEmpty((CharSequence)result.getPath())) {
            result = URI.create(UriUtils.createURI(result.getScheme(), result.getHost(), result.getPort(), "/", result.getRawQuery(), result.getRawFragment()));
        }
        return result;
    }

    public static String rewriteURI(String uri, HttpHost targetHost) {
        try {
            return URIUtils.rewriteURI((URI)UriUtils.createURI(uri), (HttpHost)targetHost).toString();
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static String removeSessionId(String sessionId, String page) {
        String regexp = ";?jsessionid=" + Pattern.quote(sessionId);
        return page.replaceAll(regexp, "");
    }

    public static String extractScheme(String uri) {
        return UriUtils.extractHost(uri).getSchemeName();
    }

    public static String getRawQuery(String uri) {
        return UriUtils.createURI(uri).getRawQuery();
    }

    public static String getPath(String uri) {
        return UriUtils.createURI(uri).getPath();
    }

    public static List<NameValuePair> parse(String uri, String charset) {
        return URLEncodedUtils.parse((URI)UriUtils.createURI(uri), (String)charset);
    }

    public static boolean isAbsolute(String uri) {
        return uri.startsWith("http://") || uri.startsWith("https://");
    }

    public static URI concatPath(URI base, String relPath) {
        String resultPath = base.getPath() + StringUtils.stripStart((String)relPath, (String)"/");
        try {
            URI result = new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), resultPath, null, null);
            return result;
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static URI removeServer(URI uri) {
        try {
            return new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static URI resolve(String relUri, URI base) {
        URI uri = UriUtils.createURI(relUri);
        if (uri.getScheme() == null && uri.getUserInfo() == null && uri.getHost() == null && uri.getPort() == -1 && StringUtils.isEmpty((CharSequence)uri.getPath()) && uri.getQuery() != null) {
            try {
                return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), base.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new InvalidUriException(e);
            }
        }
        return base.resolve(uri);
    }

    public static String removeQuerystring(String uriString) {
        URI uri = UriUtils.createURI(uriString);
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    static {
        for (int i = 0; i < 128; ++i) {
            char character = (char)i;
            String charString = Character.toString(character);
            if (RESERVED_CHARACTERS.indexOf(i) == -1) {
                charString = UriUtils.encode(charString);
            }
            UriUtils.CONVERSION_TABLE[i] = charString;
        }
    }

    private static final class InvalidUriException
    extends RuntimeException {
        private static final long serialVersionUID = 7013885420191182730L;

        private InvalidUriException(URISyntaxException cause) {
            super(cause);
        }
    }
}

