/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.http;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.esigate.http.BasicCloseableHttpResponse;

public class HttpResponseBuilder {
    private ProtocolVersion protocolVersion = new ProtocolVersion("HTTP", 1, 1);
    private int status = 200;
    private String reason = "Ok";
    private List<Header> headers = new ArrayList<Header>();
    private HttpEntity entity = null;

    public CloseableHttpResponse build() {
        BasicHttpResponse response = new BasicHttpResponse(this.protocolVersion, this.status, this.reason);
        for (Header h : this.headers) {
            response.addHeader(h.getName(), h.getValue());
        }
        if (this.entity != null) {
            response.setEntity(this.entity);
        }
        return BasicCloseableHttpResponse.adapt((HttpResponse)response);
    }

    public HttpResponseBuilder entity(HttpEntity paramEntity) {
        this.entity = paramEntity;
        if (this.entity.getContentType() != null) {
            this.headers.add(this.entity.getContentType());
        }
        return this;
    }

    public HttpResponseBuilder entity(String entityBody) throws UnsupportedEncodingException {
        this.entity = new StringEntity(entityBody);
        return this;
    }

    public HttpResponseBuilder header(String name, String value) {
        this.headers.add((Header)new BasicHeader(name, value));
        return this;
    }

    public HttpResponseBuilder protocolVersion(ProtocolVersion paramProtocolVersion) {
        this.protocolVersion = paramProtocolVersion;
        return this;
    }

    public HttpResponseBuilder reason(String paramReason) {
        this.reason = paramReason;
        return this;
    }

    public HttpResponseBuilder status(int paramStatus) {
        this.status = paramStatus;
        return this;
    }
}

