/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.net.URI;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(UrlRewriter.class);
    private static final Pattern URL_PATTERN = Pattern.compile("<([^\\!:>]+)(src|href|action|background|content)\\s*=\\s*('[^<']*'|\"[^<\"]*\")([^>]*)>", 2);
    private static final Pattern JAVASCRIPT_CONCATENATION_PATTERN = Pattern.compile("\\+\\s*'|\\+\\s*\"|'\\s*\\+|\"\\s*\\+", 2);
    private static final Pattern META_REFRESH_PATTERN = Pattern.compile("<\\s*meta([^>]+)http-equiv\\s*=\\s*(\"|')refresh(\"|')", 2);

    public UrlRewriter(Properties properties) {
    }

    public String rewriteReferer(String referer, String baseUrl, String visibleBaseUrl) {
        URI visibleBaseUri;
        URI relativeUri;
        URI uri = UriUtils.createURI(referer);
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        URI baseUri = UriUtils.createURI(baseUrl);
        if (!visibleBaseUrl.endsWith("/")) {
            visibleBaseUrl = visibleBaseUrl + "/";
        }
        if ((relativeUri = (visibleBaseUri = UriUtils.createURI(visibleBaseUrl)).relativize(uri)).equals(uri)) {
            LOG.debug("url kept unchanged: [{}]", (Object)referer);
            return referer;
        }
        URI result = baseUri.resolve(relativeUri);
        LOG.debug("referer fixed: [{}] -> [{}]", (Object)referer, (Object)result);
        return result.toString();
    }

    public String rewriteUrl(String url, String requestUrl, String baseUrl, String visibleBaseUrl, boolean absolute) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        URI baseUri = UriUtils.createURI(baseUrl);
        if (!visibleBaseUrl.endsWith("/")) {
            visibleBaseUrl = visibleBaseUrl + "/";
        }
        URI visibleBaseUri = UriUtils.createURI(visibleBaseUrl);
        URI requestUri = requestUrl.startsWith(visibleBaseUrl) ? UriUtils.createURI(requestUrl) : UriUtils.concatPath(baseUri, requestUrl);
        URI uri = UriUtils.resolve(url, requestUri);
        URI relativeUri = baseUri.relativize(uri = uri.normalize());
        if (relativeUri.equals(uri)) {
            LOG.debug("url kept unchanged: [{}]", (Object)url);
            return url;
        }
        URI result = visibleBaseUri.resolve(relativeUri);
        if (!absolute) {
            result = UriUtils.removeServer(result);
        }
        LOG.debug("url fixed: [{}] -> [{}]", (Object)url, (Object)result);
        return result.toString();
    }

    public CharSequence rewriteHtml(CharSequence input, String requestUrl, String baseUrlParam, String visibleBaseUrl, boolean absolute) {
        StringBuffer result = new StringBuffer(input.length());
        Matcher m = URL_PATTERN.matcher(input);
        while (m.find()) {
            String url = input.subSequence(m.start(3) + 1, m.end(3) - 1).toString();
            String tag = m.group(0);
            String quote = input.subSequence(m.end(3) - 1, m.end(3)).toString();
            String trimmedUrl = StringUtils.trim((String)url);
            String rewrittenUrl = url;
            if ((trimmedUrl = this.unescapeHtml(trimmedUrl)).isEmpty()) {
                LOG.debug("empty url kept unchanged");
            } else if (trimmedUrl.startsWith("#")) {
                LOG.debug("anchor url kept unchanged: [{}]", (Object)url);
            } else if (JAVASCRIPT_CONCATENATION_PATTERN.matcher(trimmedUrl).find()) {
                LOG.debug("url in javascript kept unchanged: [{}]", (Object)url);
            } else if (m.group(2).equalsIgnoreCase("content")) {
                if (META_REFRESH_PATTERN.matcher(tag).find()) {
                    rewrittenUrl = this.rewriteRefresh(trimmedUrl, requestUrl, baseUrlParam, visibleBaseUrl);
                    rewrittenUrl = this.escapeHtml(rewrittenUrl);
                    LOG.debug("refresh url [{}] rewritten [{}]", (Object)url, (Object)rewrittenUrl);
                } else {
                    LOG.debug("content attribute kept unchanged: [{}]", (Object)url);
                }
            } else {
                rewrittenUrl = this.rewriteUrl(trimmedUrl, requestUrl, baseUrlParam, visibleBaseUrl, absolute);
                rewrittenUrl = this.escapeHtml(rewrittenUrl);
                LOG.debug("url [{}] rewritten [{}]", (Object)url, (Object)rewrittenUrl);
            }
            m.appendReplacement(result, "");
            result.append("<");
            result.append(m.group(1));
            result.append(m.group(2));
            result.append("=");
            result.append(quote);
            result.append(rewrittenUrl);
            result.append(quote);
            if (m.groupCount() > 3) {
                result.append(m.group(4));
            }
            result.append(">");
        }
        m.appendTail(result);
        return result;
    }

    private String unescapeHtml(String url) {
        url = StringEscapeUtils.unescapeHtml4((String)url);
        return url;
    }

    private String escapeHtml(String url) {
        url = StringEscapeUtils.escapeHtml4((String)url);
        url = url.replaceAll("'", "&apos;");
        url = url.replaceAll("\"", "&quot;");
        return url;
    }

    public String rewriteRefresh(String input, String requestUrl, String baseUrl, String visibleBaseUrl) {
        int urlPosition = input.indexOf("url=");
        if (urlPosition >= 0) {
            String urlValue = input.substring(urlPosition + "url=".length());
            String targetUrlValue = this.rewriteUrl(urlValue, requestUrl, baseUrl, visibleBaseUrl, true);
            return input.substring(0, urlPosition) + "url=" + targetUrlValue;
        }
        return input;
    }
}

