/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.net.URL;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicRequestLine;
import org.esigate.UserContext;
import org.esigate.api.ContainerRequestContext;
import org.esigate.http.OutgoingRequestContext;
import org.esigate.impl.DriverRequest;

public class OutgoingRequest
extends BasicHttpEntityEnclosingRequest
implements Configurable {
    private RequestLine requestLine;
    private final RequestConfig requestConfig;
    private final OutgoingRequestContext context;
    private final DriverRequest originalRequest;

    public OutgoingRequest(String method, String uri, ProtocolVersion version, DriverRequest originalRequest, RequestConfig requestConfig, OutgoingRequestContext context) {
        super(method, uri, version);
        this.requestLine = new BasicRequestLine(method, uri, version);
        this.requestConfig = requestConfig;
        this.context = context;
        this.originalRequest = originalRequest;
    }

    public void setUri(String uri) {
        this.requestLine = new BasicRequestLine(this.requestLine.getMethod(), uri, this.requestLine.getProtocolVersion());
    }

    public ProtocolVersion getProtocolVersion() {
        return this.requestLine.getProtocolVersion();
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public String toString() {
        return this.requestLine.toString();
    }

    public RequestConfig getConfig() {
        return this.requestConfig;
    }

    public OutgoingRequestContext getContext() {
        return this.context;
    }

    public UserContext getUserContext() {
        return this.originalRequest.getUserContext();
    }

    public ContainerRequestContext getContainerRequestContext() {
        return this.originalRequest.getContext();
    }

    public URL getBaseUrl() {
        return this.originalRequest.getBaseUrl();
    }

    public DriverRequest getOriginalRequest() {
        return this.originalRequest;
    }
}

