/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;
import org.esigate.HttpErrorPage;
import org.esigate.events.EventManager;
import org.esigate.events.impl.ReadEntityEvent;
import org.esigate.http.UnsupportedContentEncodingException;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpResponseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseUtils.class);
    private static final int OUTPUT_BUFFER_SIZE = 4096;

    private HttpResponseUtils() {
    }

    public static boolean isError(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode() >= 400;
    }

    public static String getFirstHeader(String headerName, HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public static String removeSessionId(String uri, HttpResponse httpResponse) {
        BrowserCompatSpec cookieSpec = new BrowserCompatSpec();
        CookieOrigin cookieOrigin = new CookieOrigin("dummy", 80, "/", false);
        Header[] responseHeaders = httpResponse.getHeaders("Set-cookie");
        String jsessionid = null;
        for (int i = 0; i < responseHeaders.length; ++i) {
            Header header = responseHeaders[i];
            try {
                Cookie cookie;
                List cookies = cookieSpec.parse(header, cookieOrigin);
                Iterator i$ = cookies.iterator();
                if (i$.hasNext() && "JSESSIONID".equalsIgnoreCase((cookie = (Cookie)i$.next()).getName())) {
                    jsessionid = cookie.getValue();
                }
            }
            catch (MalformedCookieException ex) {
                LOG.warn("Malformed header: " + header.getName() + ": " + header.getValue());
            }
            if (jsessionid != null) break;
        }
        if (jsessionid == null) {
            return uri;
        }
        return UriUtils.removeSessionId(jsessionid, uri);
    }

    public static String toString(HttpResponse httpResponse, EventManager eventManager) throws HttpErrorPage {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            Header contentEncoding = httpEntity.getContentEncoding();
            if (contentEncoding != null) {
                String contentEncodingValue = contentEncoding.getValue();
                if ("gzip".equalsIgnoreCase(contentEncodingValue) || "x-gzip".equalsIgnoreCase(contentEncodingValue)) {
                    httpEntity = new GzipDecompressingEntity(httpEntity);
                } else if ("deflate".equalsIgnoreCase(contentEncodingValue)) {
                    httpEntity = new DeflateDecompressingEntity(httpEntity);
                } else {
                    throw new UnsupportedContentEncodingException("Content-encoding \"" + contentEncoding + "\" is not supported");
                }
            }
            try {
                byte[] rawEntityContent = EntityUtils.toByteArray((HttpEntity)httpEntity);
                ContentType contentType = null;
                Charset charset = null;
                String mimeType = null;
                try {
                    contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
                    mimeType = contentType.getMimeType();
                    charset = contentType.getCharset();
                }
                catch (UnsupportedCharsetException ex) {
                    throw new UnsupportedEncodingException(ex.getMessage());
                }
                if (charset == null) {
                    charset = HTTP.DEF_CONTENT_CHARSET;
                }
                ReadEntityEvent event = new ReadEntityEvent(mimeType, charset, rawEntityContent);
                event.setEntityContent(new String(rawEntityContent, charset));
                if (eventManager != null) {
                    eventManager.fire(EventManager.EVENT_READ_ENTITY, event);
                }
                return event.getEntityContent();
            }
            catch (IOException e) {
                throw new HttpErrorPage(HttpErrorPage.generateHttpResponse(e));
            }
        }
        String result = httpResponse.getStatusLine().getReasonPhrase();
        return HttpResponseUtils.removeSessionId(result, httpResponse);
    }

    public static ContentType getContentType(CloseableHttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return ContentType.get((HttpEntity)entity);
    }

    public static String toString(CloseableHttpResponse response) throws HttpErrorPage {
        return HttpResponseUtils.toString((HttpResponse)response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(HttpEntity httpEntity, OutputStream outstream) throws IOException {
        block7: {
            Args.notNull((Object)outstream, (String)"Output stream");
            try (InputStream instream = httpEntity.getContent();){
                int l;
                byte[] buffer = new byte[4096];
                if (httpEntity.getContentLength() < 0L) {
                    int l2;
                    while ((l2 = instream.read(buffer)) != -1) {
                        outstream.write(buffer, 0, l2);
                        outstream.flush();
                        LOG.debug("Flushed {} bytes of data");
                    }
                    break block7;
                }
                for (long remaining = httpEntity.getContentLength(); remaining > 0L; remaining -= (long)l) {
                    l = instream.read(buffer, 0, (int)Math.min(4096L, remaining));
                    if (l == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, l);
                    outstream.flush();
                    LOG.debug("Flushed {} bytes of data");
                }
            }
        }
    }
}

