/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.io.File;
import java.util.Properties;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.extension.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ConfigReloadOnHup
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigReloadOnHup.class);
    private static final String SIGNAL_NAME = "HUP";
    private static File configuration = null;
    private static final SignalHandler SH = new SignalHandler(){

        @Override
        public void handle(Signal signal) {
            if (ConfigReloadOnHup.SIGNAL_NAME.equals(signal.getName())) {
                LOG.warn("Signal HUP received. Reloading configuration.");
                DriverFactory.configure();
            }
        }
    };

    @Override
    public void init(Driver driver, Properties properties) {
    }

    static {
        String envPath = System.getProperty("esigate.config");
        if (envPath != null) {
            configuration = new File(envPath);
            Signal signal = new Signal(SIGNAL_NAME);
            Signal.handle(signal, SH);
            LOG.info("Will reload configuration from {} on signal {}", (Object)configuration.getAbsoluteFile(), (Object)signal.getNumber());
        } else {
            LOG.warn("Cannot reload configuration from classpath. Please use -Desigate.config");
        }
    }
}

