/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.surrogate.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.esigate.extension.surrogate.http.SurrogateCapabilities;

public final class SurrogateCapabilitiesHeader {
    private List<SurrogateCapabilities> surrogates = new ArrayList<SurrogateCapabilities>();

    private SurrogateCapabilitiesHeader() {
    }

    public static SurrogateCapabilitiesHeader fromHeaderValue(String value) {
        String[] surrogates;
        SurrogateCapabilitiesHeader result = new SurrogateCapabilitiesHeader();
        if (value == null) {
            return result;
        }
        for (String surrogate : surrogates = value.split(",")) {
            result.surrogates.add(SurrogateCapabilities.fromString(surrogate.trim()));
        }
        return result;
    }

    public List<SurrogateCapabilities> getSurrogates() {
        return this.surrogates;
    }

    public SurrogateCapabilities getSurrogate(String token) {
        for (SurrogateCapabilities s : this.surrogates) {
            if (!token.equals(s.getDeviceToken())) continue;
            return s;
        }
        return null;
    }

    public String toString() {
        return StringUtils.join(this.surrogates, (String)", ");
    }
}

