/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.surrogate.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.esigate.extension.surrogate.http.Capability;

public final class SurrogateCapabilities {
    private List<Capability> capabilities = new ArrayList<Capability>();
    private String deviceToken = null;

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    private SurrogateCapabilities() {
    }

    public static SurrogateCapabilities fromString(String surrogateString) {
        SurrogateCapabilities cap = new SurrogateCapabilities();
        int equalsIndex = surrogateString.indexOf(61);
        if (equalsIndex >= 0) {
            String[] capabilities;
            cap.deviceToken = surrogateString.substring(0, equalsIndex).trim();
            String allCapabiities = surrogateString.substring(equalsIndex + 1).trim();
            if (allCapabiities.startsWith("\"") && allCapabiities.endsWith("\"")) {
                allCapabiities = allCapabiities.substring(1, allCapabiities.length() - 1);
            }
            for (String c : capabilities = allCapabiities.split(" ")) {
                if ((c = c.trim()).length() <= 0) continue;
                cap.capabilities.add(Capability.fromToken(c));
            }
        }
        return cap;
    }

    public String toString() {
        return this.deviceToken + "=" + "\"" + StringUtils.join(this.capabilities, (String)" ") + "\"";
    }
}

