/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.util.Properties;
import org.apache.http.impl.client.cache.CacheConfig;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.cache.CacheStorage;

public final class CacheConfigHelper {
    private CacheConfigHelper() {
    }

    public static CacheConfig createCacheConfig(Properties properties) {
        boolean heuristicCachingEnabled = Parameters.HEURISTIC_CACHING_ENABLED.getValue(properties);
        float heuristicCoefficient = Parameters.HEURISTIC_COEFFICIENT.getValue(properties).floatValue();
        long heuristicDefaultLifetimeSecs = Parameters.HEURISTIC_DEFAULT_LIFETIME_SECS.getValue(properties).intValue();
        int maxCacheEntries = Parameters.MAX_CACHE_ENTRIES.getValue(properties);
        long maxObjectSize = Parameters.MAX_OBJECT_SIZE.getValue(properties).intValue();
        int minAsynchronousWorkers = Parameters.MIN_ASYNCHRONOUS_WORKERS.getValue(properties);
        int maxAsynchronousWorkers = Parameters.MAX_ASYNCHRONOUS_WORKERS.getValue(properties);
        int asynchronousWorkerIdleLifetimeSecs = Parameters.ASYNCHRONOUS_WORKER_IDLE_LIFETIME_SECS.getValue(properties);
        int maxUpdateRetries = Parameters.MAX_UPDATE_RETRIES.getValue(properties);
        int revalidationQueueSize = Parameters.REVALIDATION_QUEUE_SIZE.getValue(properties);
        CacheConfig.Builder builder = CacheConfig.custom();
        builder.setHeuristicCachingEnabled(heuristicCachingEnabled);
        builder.setHeuristicCoefficient(heuristicCoefficient);
        builder.setHeuristicDefaultLifetime(heuristicDefaultLifetimeSecs);
        builder.setMaxCacheEntries(maxCacheEntries);
        long usedMaxObjectSize = Long.MAX_VALUE;
        if (maxObjectSize > 0L) {
            usedMaxObjectSize = maxObjectSize;
        }
        builder.setMaxObjectSize(usedMaxObjectSize);
        builder.setAsynchronousWorkersCore(minAsynchronousWorkers);
        builder.setAsynchronousWorkersMax(maxAsynchronousWorkers);
        builder.setAsynchronousWorkerIdleLifetimeSecs(asynchronousWorkerIdleLifetimeSecs);
        builder.setMaxUpdateRetries(maxUpdateRetries).setRevalidationQueueSize(revalidationQueueSize);
        builder.setSharedCache(true);
        return builder.build();
    }

    public static CacheStorage createCacheStorage(Properties properties) {
        Object cacheStorageObject;
        String cacheStorageClass = Parameters.CACHE_STORAGE.getValue(properties);
        try {
            cacheStorageObject = Class.forName(cacheStorageClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not instantiate cacheStorageClass", e);
        }
        if (!(cacheStorageObject instanceof CacheStorage)) {
            throw new ConfigurationException("Cache storage class must extend org.esigate.cache.CacheStorage.");
        }
        CacheStorage cacheStorage = (CacheStorage)cacheStorageObject;
        cacheStorage.init(properties);
        return cacheStorage;
    }
}

