/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser.future;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.esigate.HttpErrorPage;
import org.esigate.impl.DriverRequest;
import org.esigate.parser.future.CharSequenceFuture;
import org.esigate.parser.future.FutureAppendable;
import org.esigate.parser.future.FutureElement;
import org.esigate.parser.future.FutureElementType;
import org.esigate.parser.future.FutureParserContextImpl;
import org.esigate.parser.future.UnknownElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureParser {
    private static final Logger LOG = LoggerFactory.getLogger(FutureParser.class);
    private final Pattern pattern;
    private final List<FutureElementType> elementTypes;
    private DriverRequest httpRequest;
    private HttpResponse httpResponse;
    private Map<String, Object> data = null;

    public FutureParser(Pattern pattern, FutureElementType ... elementTypes) {
        this.pattern = pattern;
        this.elementTypes = new ArrayList<FutureElementType>(elementTypes.length + 1);
        for (FutureElementType elementType : elementTypes) {
            this.elementTypes.add(elementType);
        }
        this.elementTypes.add(UnknownElement.TYPE);
    }

    public void parse(CharSequence in, FutureAppendable out) throws IOException, HttpErrorPage {
        FutureParserContextImpl ctx = new FutureParserContextImpl(out, this.httpRequest, this.httpResponse, this.data);
        Matcher matcher = this.pattern.matcher(in);
        int currentPosition = 0;
        while (matcher.find()) {
            String tag = matcher.group();
            ctx.characters(new CharSequenceFuture(in.subSequence(currentPosition, matcher.start())));
            currentPosition = matcher.end();
            if (ctx.isCurrentTagEnd(tag)) {
                LOG.info("Processing end tag {}", (Object)tag);
                ctx.endElement(tag);
                continue;
            }
            LOG.info("Processing start tag {}", (Object)tag);
            FutureElementType type = null;
            for (FutureElementType t : this.elementTypes) {
                if (!t.isStartTag(tag)) continue;
                type = t;
                break;
            }
            FutureElement element = type.newInstance();
            ctx.startElement(type, element, tag);
            if (!element.isClosed()) continue;
            ctx.endElement(tag);
        }
        ctx.characters(new CharSequenceFuture(in.subSequence(currentPosition, in.length())));
    }

    public void setHttpRequest(DriverRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setData(String key, Object o) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, o);
    }
}

