/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser.future;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.esigate.HttpErrorPage;
import org.esigate.parser.future.FutureAppendable;

public class FutureAppendableAdapter
implements FutureAppendable {
    private Appendable out;
    private List<Future<CharSequence>> futureList;

    public FutureAppendableAdapter(Appendable out) {
        this.out = out;
        this.futureList = new ArrayList<Future<CharSequence>>();
    }

    @Override
    public FutureAppendable enqueueAppend(Future<CharSequence> csq) {
        this.futureList.add(csq);
        return this;
    }

    @Override
    public FutureAppendable performAppends(int timeout, TimeUnit unit) throws IOException, HttpErrorPage, TimeoutException {
        try {
            for (Future<CharSequence> f : this.futureList) {
                CharSequence csq = f.get(timeout, unit);
                this.out.append(csq);
            }
        }
        catch (InterruptedException | CancellationException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpErrorPage) {
                throw (HttpErrorPage)e.getCause();
            }
            throw new IOException(e);
        }
        this.futureList.clear();
        return this;
    }

    @Override
    public boolean hasPending() {
        return this.futureList.size() > 0;
    }

    @Override
    public FutureAppendable performAppends() throws IOException, HttpErrorPage {
        try {
            for (Future<CharSequence> f : this.futureList) {
                CharSequence csq = f.get();
                this.out.append(csq);
            }
        }
        catch (InterruptedException | CancellationException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpErrorPage) {
                throw (HttpErrorPage)e.getCause();
            }
            throw new IOException(e);
        }
        this.futureList.clear();
        return this;
    }
}

