/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.UserContext;
import org.esigate.api.ContainerRequestContext;
import org.esigate.http.IncomingRequest;
import org.esigate.util.UriUtils;

public class DriverRequest {
    private final IncomingRequest wrappedRequest;
    private final Driver driver;
    private final UserContext userContext;
    private final URL baseUrl;
    private final String visibleBaseUrl;
    private final boolean external;
    private String characterEncoding;

    public DriverRequest(IncomingRequest request, Driver driver, String relUrl) throws HttpErrorPage {
        this.wrappedRequest = request;
        this.driver = driver;
        this.external = UriUtils.isAbsolute(relUrl);
        this.userContext = new UserContext(request, driver.getConfiguration().getInstanceName());
        try {
            this.baseUrl = new URL(driver.getConfiguration().getBaseUrlRetrieveStrategy().getBaseURL(request));
        }
        catch (MalformedURLException e) {
            throw new HttpErrorPage(500, "Internal server error", e);
        }
        String visibleBase = driver.getConfiguration().getVisibleBaseURL();
        if (visibleBase == null) {
            String requestUri = request.getRequestLine().getUri();
            requestUri = UriUtils.removeQuerystring(requestUri);
            visibleBase = !this.external && requestUri.endsWith(relUrl) ? requestUri.substring(0, requestUri.length() - relUrl.length()) : this.baseUrl.toString();
        }
        this.visibleBaseUrl = UriUtils.rewriteURI(visibleBase, UriUtils.extractHost(request.getRequestLine().getUri()));
    }

    public Driver getDriver() {
        return this.driver;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public ContainerRequestContext getContext() {
        return this.wrappedRequest.getContext();
    }

    public IncomingRequest getOriginalRequest() {
        return this.wrappedRequest;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getVisibleBaseUrl() {
        return this.visibleBaseUrl;
    }
}

