/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http.cookie;

import org.apache.http.HeaderElement;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueFormatter;

public final class CookieUtil {
    private static final int ONE_SECOND = 1000;
    public static final String HTTP_ONLY_ATTR = "httponly";

    private CookieUtil() {
    }

    public static String encodeCookie(Cookie cookie) {
        int maxAge = -1;
        if (cookie.getExpiryDate() != null && (maxAge = (int)((cookie.getExpiryDate().getTime() - System.currentTimeMillis()) / 1000L)) < 0) {
            maxAge = 0;
        }
        String cookieName = cookie.getName();
        String cookieValue = cookie.getValue();
        StringBuilder buffer = new StringBuilder();
        if (cookie.getVersion() > 0 && !CookieUtil.isQuoteEnclosed(cookieValue)) {
            buffer.append(BasicHeaderValueFormatter.INSTANCE.formatHeaderElement(null, (HeaderElement)new BasicHeaderElement(cookieName, cookieValue), false).toString());
        } else {
            buffer.append(cookieName);
            buffer.append("=");
            if (cookieValue != null) {
                buffer.append(cookieValue);
            }
        }
        CookieUtil.appendAttribute(buffer, "Comment", cookie.getComment());
        CookieUtil.appendAttribute(buffer, "Domain", cookie.getDomain());
        CookieUtil.appendAttribute(buffer, "Max-Age", maxAge);
        CookieUtil.appendAttribute(buffer, "Path", cookie.getPath());
        if (cookie.isSecure()) {
            CookieUtil.appendAttribute(buffer, "Secure");
        }
        if (((BasicClientCookie)cookie).containsAttribute(HTTP_ONLY_ATTR)) {
            CookieUtil.appendAttribute(buffer, "HttpOnly");
        }
        CookieUtil.appendAttribute(buffer, "Version", cookie.getVersion());
        return buffer.toString();
    }

    private static void appendAttribute(StringBuilder buffer, String name, String value) {
        if (value != null) {
            buffer.append("; ");
            buffer.append(name);
            buffer.append("=");
            buffer.append(value);
        }
    }

    private static void appendAttribute(StringBuilder buffer, String name, int value) {
        if (value > 0) {
            CookieUtil.appendAttribute(buffer, name, Integer.toString(value));
        }
    }

    private static void appendAttribute(StringBuilder buffer, String name) {
        buffer.append("; ");
        buffer.append(name);
    }

    private static boolean isQuoteEnclosed(String s) {
        return s != null && s.startsWith("\"") && s.endsWith("\"");
    }
}

