/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.esigate.http.OutgoingRequest;

public class OutgoingRequestContext
extends HttpClientContext {
    private static final String PROXY = "PROXY";
    private static final String OUTGOING_REQUEST = "OUTGOING_REQUEST";
    private static final String PHYSICAL_HOST = "PHYSICAL_HOST";

    public static OutgoingRequestContext adapt(HttpContext context) {
        if (context instanceof OutgoingRequestContext) {
            return (OutgoingRequestContext)context;
        }
        return new OutgoingRequestContext(context);
    }

    private OutgoingRequestContext(HttpContext context) {
        super(context);
    }

    OutgoingRequestContext() {
    }

    public boolean isProxy() {
        Boolean proxy = (Boolean)this.getAttribute(PROXY, Boolean.class);
        if (proxy == null) {
            return false;
        }
        return proxy;
    }

    void setProxy(boolean proxy) {
        this.setAttribute(PROXY, proxy);
    }

    public OutgoingRequest getOutgoingRequest() {
        return (OutgoingRequest)((Object)this.getAttribute(OUTGOING_REQUEST, OutgoingRequest.class));
    }

    void setOutgoingRequest(OutgoingRequest outgoingRequest) {
        this.setAttribute(OUTGOING_REQUEST, (Object)outgoingRequest);
    }

    HttpHost getPhysicalHost() {
        return (HttpHost)this.getAttribute(PHYSICAL_HOST, HttpHost.class);
    }

    void setPhysicalHost(HttpHost httpHost) {
        this.setAttribute(PHYSICAL_HOST, httpHost);
    }

    public void setAttribute(String id, Object obj, boolean save) {
        if (save) {
            String historyAttribute = id + "history";
            LinkedList<Object> history = (LinkedList<Object>)this.getAttribute(historyAttribute);
            if (history == null) {
                history = new LinkedList<Object>();
                this.setAttribute(historyAttribute, history);
            }
            if (this.getAttribute(id) != null) {
                history.add(this.getAttribute(id));
            }
        }
        this.setAttribute(id, obj);
    }

    public Object removeAttribute(String id, boolean restore) {
        String historyAttribute;
        Queue history;
        Object value = this.removeAttribute(id);
        if (restore && (history = (Queue)this.getAttribute(historyAttribute = id + "history")) != null && !history.isEmpty()) {
            Object previous = history.remove();
            this.setAttribute(id, previous);
        }
        return value;
    }
}

