/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.monitoring;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.cache.CacheResponseStatus;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.extension.Extension;
import org.esigate.util.Parameter;
import org.esigate.util.ParameterInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metric
implements Extension,
IEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Metric.class);
    private static final Parameter<Integer> PARAM_METRIC_PERIOD = new ParameterInteger("metricPeriod", 60);
    private MetricRegistry metric = new MetricRegistry();
    private ScheduledReporter reporter;
    private Driver driver;

    @Override
    public void init(Driver d, Properties properties) {
        this.driver = d;
        LOG.debug("Initialize Metric");
        this.driver.getEventManager().register(EventManager.EVENT_PROXY_POST, this);
        this.driver.getEventManager().register(EventManager.EVENT_FETCH_POST, this);
        this.reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metric).outputTo(LOG).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        this.reporter.start((long)PARAM_METRIC_PERIOD.getValue(properties).intValue(), TimeUnit.SECONDS);
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        String timerName = MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{this.driver.getConfiguration().getInstanceName(), id.getId()});
        if (EventManager.EVENT_PROXY_POST.equals(id)) {
            if (((ProxyEvent)event).getErrorPage() != null) {
                String statusCode = String.valueOf(((ProxyEvent)event).getErrorPage().getHttpResponse().getStatusLine().getStatusCode());
                timerName = MetricRegistry.name((String)timerName, (String[])new String[]{"error", statusCode});
            }
        } else if (EventManager.EVENT_FETCH_POST.equals(id)) {
            FetchEvent e = (FetchEvent)event;
            int statusCode = e.getHttpResponse().getStatusLine().getStatusCode();
            CacheResponseStatus cacheResponseStatus = (CacheResponseStatus)e.getHttpContext().getAttribute("http.cache.response.status");
            if (statusCode >= 400) {
                timerName = MetricRegistry.name((String)timerName, (String[])new String[]{"error", String.valueOf(statusCode)});
            }
            if (cacheResponseStatus != null && !cacheResponseStatus.equals((Object)CacheResponseStatus.CACHE_MISS)) {
                timerName = MetricRegistry.name((String)timerName, (String[])new String[]{cacheResponseStatus.name().toLowerCase()});
            }
        }
        this.metric.meter(timerName).mark();
        return true;
    }
}

