/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FetchEvent;
import org.esigate.extension.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchLogging
implements Extension,
IEventListener {
    private static final String TIME = "org.esigate.time.external";
    private static final Logger LOG = LoggerFactory.getLogger(FetchLogging.class);

    @Override
    public void init(Driver driver, Properties properties) {
        driver.getEventManager().register(EventManager.EVENT_FETCH_POST, this);
        driver.getEventManager().register(EventManager.EVENT_FETCH_PRE, this);
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        FetchEvent e = (FetchEvent)event;
        if (EventManager.EVENT_FETCH_POST.equals(id)) {
            int statusCode = e.getHttpResponse().getStatusLine().getStatusCode();
            if (LOG.isInfoEnabled() || statusCode >= 400) {
                HttpRequestWrapper lastRequest = e.getHttpRequest();
                String url = lastRequest.getRequestLine().toString();
                String status = e.getHttpResponse().getStatusLine().toString();
                String reqHeaders = ArrayUtils.toString((Object)lastRequest.getAllHeaders());
                String respHeaders = ArrayUtils.toString((Object)e.getHttpResponse().getAllHeaders());
                HttpHost targetHost = e.getHttpContext().getTargetHost();
                long time = System.currentTimeMillis() - (Long)e.getHttpContext().removeAttribute(TIME, true);
                StringBuilder logMessage = new StringBuilder(256);
                if (targetHost != null) {
                    logMessage.append(targetHost.getSchemeName());
                    logMessage.append("://");
                    logMessage.append(targetHost.getHostName());
                    if (targetHost.getPort() != -1) {
                        logMessage.append(":");
                        logMessage.append(targetHost.getPort());
                    }
                    logMessage.append(" - ");
                }
                logMessage.append(url);
                logMessage.append(" ");
                logMessage.append(reqHeaders);
                logMessage.append(" -> ");
                logMessage.append(status);
                logMessage.append(" (");
                logMessage.append(time);
                logMessage.append(" ms) ");
                logMessage.append(respHeaders);
                if (statusCode >= 400) {
                    LOG.warn(logMessage.toString());
                } else {
                    LOG.info(logMessage.toString());
                }
            }
        } else {
            e.getHttpContext().setAttribute(TIME, System.currentTimeMillis(), true);
        }
        return true;
    }
}

