/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cookie;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.Parameters;
import org.esigate.UserContext;
import org.esigate.cookie.CookieManager;
import org.esigate.impl.DriverRequest;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCookieManager
implements CookieManager {
    private static final Logger LOG = LoggerFactory.getLogger(CookieManager.class);
    private static final String COOKIES_LIST_SESSION_KEY = CookieManager.class.getName() + "#cookies";
    private Collection<String> discardCookies;
    private Collection<String> storeCookiesInSession;

    protected Collection<String> getStoredCookies() {
        return this.storeCookiesInSession;
    }

    @Override
    public void init(Driver d, Properties properties) {
        this.storeCookiesInSession = Parameters.STORE_COOKIES_IN_SESSION.getValue(properties);
        this.discardCookies = Parameters.DISCARD_COOKIES.getValue(properties);
        if (this.storeCookiesInSession.contains("*") && this.storeCookiesInSession.size() > 1) {
            throw new ConfigurationException("storeCookiesInSession must be a list of cookie names OR *");
        }
        if (this.discardCookies.contains("*") && this.discardCookies.size() > 1) {
            throw new ConfigurationException("discardCookies must be a list of cookie names OR *");
        }
        if (this.storeCookiesInSession.contains("*") && this.discardCookies.contains("*")) {
            throw new ConfigurationException("cannot use * for storeCookiesInSession AND discardCookies at the same time");
        }
    }

    @Override
    public void addCookie(Cookie cookie, DriverRequest originalRequest) {
        String name = cookie.getName();
        if (this.discardCookies.contains(name) || this.discardCookies.contains("*") && !this.storeCookiesInSession.contains(name)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cookie " + this.toString(cookie) + " -> discarding");
            }
        } else if (this.storeCookiesInSession.contains(name) || this.storeCookiesInSession.contains("*")) {
            UserContext userContext;
            BasicCookieStore cookies;
            if (LOG.isInfoEnabled()) {
                LOG.info("Cookie " + this.toString(cookie) + " -> storing to session");
            }
            if ((cookies = (BasicCookieStore)(userContext = originalRequest.getUserContext()).getAttribute(COOKIES_LIST_SESSION_KEY)) == null) {
                cookies = new BasicCookieStore();
            }
            cookies.addCookie(cookie);
            userContext.setAttribute(COOKIES_LIST_SESSION_KEY, (Serializable)cookies);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cookie " + this.toString(cookie) + " -> forwarding");
            }
            originalRequest.getOriginalRequest().addNewCookie(DefaultCookieManager.rewriteForBrowser(cookie, originalRequest));
        }
    }

    @Override
    public List<Cookie> getCookies(DriverRequest originalRequest) {
        Cookie[] requestCookies;
        BasicCookieStore cookies = new BasicCookieStore();
        UserContext userContext = originalRequest.getUserContext();
        BasicCookieStore sessionCookies = (BasicCookieStore)userContext.getAttribute(COOKIES_LIST_SESSION_KEY);
        if (sessionCookies != null) {
            for (Cookie c : sessionCookies.getCookies()) {
                cookies.addCookie(c);
            }
        }
        if ((requestCookies = originalRequest.getOriginalRequest().getCookies()) != null) {
            for (Cookie cookie : requestCookies) {
                String name = cookie.getName();
                if (this.storeCookiesInSession.contains(name) || this.storeCookiesInSession.contains("*") || this.discardCookies.contains(name) || this.discardCookies.contains("*")) continue;
                cookies.addCookie(DefaultCookieManager.rewriteForServer(cookie, originalRequest));
            }
        }
        return cookies.getCookies();
    }

    private static Cookie rewriteForServer(Cookie cookie, DriverRequest request) {
        String name = cookie.getName();
        if ("_JSESSIONID".equalsIgnoreCase(name)) {
            name = name.substring(1);
        }
        BasicClientCookie2 httpClientCookie = new BasicClientCookie2(name, cookie.getValue());
        httpClientCookie.setSecure(false);
        String domain = request.getDriver().getConfiguration().isPreserveHost() ? UriUtils.extractHostName(request.getOriginalRequest().getRequestLine().getUri()) : request.getBaseUrl().getHost();
        httpClientCookie.setDomain(domain);
        httpClientCookie.setPath("/");
        httpClientCookie.setComment(cookie.getComment());
        httpClientCookie.setVersion(cookie.getVersion());
        return httpClientCookie;
    }

    protected static String rewriteDomain(String originalDomain, String providerHostName, String requestHostName) {
        String domain = null;
        if (!providerHostName.equals(originalDomain)) {
            String[] requestHostNameParts;
            String[] originalDomainParts;
            int targetLength;
            if (originalDomain.startsWith(".")) {
                originalDomain = originalDomain.substring(1);
            }
            if ((targetLength = Math.min((originalDomainParts = originalDomain.split("\\.")).length, (requestHostNameParts = requestHostName.split("\\.")).length)) == requestHostNameParts.length) {
                return null;
            }
            domain = "";
            for (int i = requestHostNameParts.length; i > requestHostNameParts.length - targetLength; --i) {
                domain = "." + requestHostNameParts[i - 1] + domain;
            }
        }
        return domain;
    }

    protected static Cookie rewriteForBrowser(Cookie cookie, DriverRequest request) {
        String name = cookie.getName();
        if ("JSESSIONID".equalsIgnoreCase(name)) {
            name = "_" + name;
        }
        String domain = DefaultCookieManager.rewriteDomain(cookie.getDomain(), request.getBaseUrl().getHost(), UriUtils.extractHostName(request.getOriginalRequest().getRequestLine().getUri()));
        String originalPath = cookie.getPath();
        String requestPath = UriUtils.getPath(request.getOriginalRequest().getRequestLine().getUri());
        String path = originalPath;
        if (requestPath == null || !requestPath.startsWith(originalPath)) {
            path = "/";
        }
        boolean secure = cookie.isSecure() && request.getOriginalRequest().getRequestLine().getUri().startsWith("https");
        BasicClientCookie cookieToForward = new BasicClientCookie(name, cookie.getValue());
        if (domain != null) {
            cookieToForward.setDomain(domain);
        }
        cookieToForward.setPath(path);
        cookieToForward.setSecure(secure);
        cookieToForward.setComment(cookie.getComment());
        cookieToForward.setVersion(cookie.getVersion());
        cookieToForward.setExpiryDate(cookie.getExpiryDate());
        if (((BasicClientCookie)cookie).containsAttribute("httponly")) {
            cookieToForward.setAttribute("httponly", "");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding cookie {} -> {}", (Object)cookie.toString(), (Object)cookieToForward.toString());
        }
        return cookieToForward;
    }

    private String toString(Cookie cookie) {
        StringBuilder result = new StringBuilder(256);
        result.append(cookie.getName());
        result.append("=");
        result.append(cookie.getValue());
        if (cookie.getDomain() != null) {
            result.append(";domain=");
            result.append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            result.append(";path=");
            result.append(cookie.getPath());
        }
        if (cookie.getExpiryDate() != null) {
            result.append(";expires=");
            result.append(cookie.getExpiryDate());
        }
        if (cookie.getCommentURL() != null) {
            result.append(";comment=");
            result.append(cookie.getComment());
        }
        if (cookie.getCommentURL() != null) {
            result.append(";comment=");
            result.append(cookie.getCommentURL());
        }
        return result.toString();
    }

    @Override
    public boolean clearExpired(Date date, DriverRequest request) {
        UserContext userContext = request.getUserContext();
        BasicCookieStore cookies = (BasicCookieStore)userContext.getAttribute(COOKIES_LIST_SESSION_KEY);
        if (cookies != null) {
            return cookies.clearExpired(date);
        }
        return false;
    }

    @Override
    public void clear(DriverRequest request) {
        UserContext userContext = request.getUserContext();
        BasicCookieStore cookies = (BasicCookieStore)userContext.getAttribute(COOKIES_LIST_SESSION_KEY);
        if (cookies != null) {
            cookies.clear();
            userContext.setAttribute(COOKIES_LIST_SESSION_KEY, (Serializable)cookies);
        }
    }
}

