/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.dom.Dom2Sax;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.http.HttpResponseUtils;
import org.esigate.impl.DriverRequest;
import org.esigate.xml.ProcessingFailedException;
import org.esigate.xml.XhtmlSerializer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XsltRenderer
implements Renderer {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private Transformer transformer;

    public XsltRenderer(String template, Driver driver, DriverRequest originalRequest) throws IOException, HttpErrorPage {
        StringBuilder templateStringBuilder = new StringBuilder();
        CloseableHttpResponse response = driver.render(template, originalRequest.getOriginalRequest(), new Renderer[0]);
        templateStringBuilder.append(HttpResponseUtils.toString(response));
        this.transformer = XsltRenderer.createTransformer(IOUtils.toInputStream((CharSequence)templateStringBuilder));
    }

    public XsltRenderer(String xsl) throws IOException {
        InputStream templateStream = IOUtils.toInputStream((String)xsl);
        this.transformer = XsltRenderer.createTransformer(templateStream);
    }

    private static Transformer createTransformer(InputStream templateStream) throws IOException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(templateStream));
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new ProcessingFailedException("Failed to create XSLT template", e);
        }
        finally {
            templateStream.close();
        }
    }

    @Override
    public void render(DriverRequest httpRequest, String src, Writer out) throws IOException {
        try {
            HtmlDocumentBuilder htmlDocumentBuilder = new HtmlDocumentBuilder();
            htmlDocumentBuilder.setDoctypeExpectation(DoctypeExpectation.NO_DOCTYPE_ERRORS);
            Document document = htmlDocumentBuilder.parse(new InputSource(new StringReader(src)));
            DOMSource source = new DOMSource(document);
            DOMResult result = new DOMResult();
            this.transformer.transform(source, result);
            XhtmlSerializer serializer = new XhtmlSerializer(out);
            Dom2Sax dom2Sax = new Dom2Sax((ContentHandler)((Object)serializer), (LexicalHandler)((Object)serializer));
            dom2Sax.parse(result.getNode());
        }
        catch (TransformerException e) {
            throw new ProcessingFailedException("Failed to transform source", e);
        }
        catch (SAXException e) {
            throw new ProcessingFailedException("Failed serialize transformation result", e);
        }
    }
}

