/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test;

import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicRequestLine;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.api.ContainerRequestContext;
import org.esigate.http.IncomingRequest;
import org.esigate.impl.DriverRequest;
import org.esigate.test.MockSession;
import org.esigate.util.UriUtils;

public final class TestUtils {
    private TestUtils() {
    }

    public static IncomingRequest.Builder createIncomingRequest(String uri) {
        HttpHost httpHost = UriUtils.extractHost(uri);
        String scheme = httpHost.getSchemeName();
        String host = httpHost.getHostName();
        int port = httpHost.getPort();
        BasicRequestLine requestLine = new BasicRequestLine("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        IncomingRequest.Builder builder = IncomingRequest.builder((RequestLine)requestLine);
        builder.setContext(new ContainerRequestContext(){});
        if (port == -1 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme)) {
            builder.addHeader("Host", host);
        } else {
            builder.addHeader("Host", host + ":" + port);
        }
        builder.setSession(new MockSession());
        return builder;
    }

    public static IncomingRequest.Builder createIncomingRequest() {
        return TestUtils.createIncomingRequest("http://localhost:8080");
    }

    public static DriverRequest createDriverRequest(String uri, Driver driver) throws HttpErrorPage {
        IncomingRequest request = TestUtils.createIncomingRequest(uri).build();
        return new DriverRequest(request, driver, false);
    }

    public static DriverRequest createDriverRequest(Driver driver) throws HttpErrorPage {
        IncomingRequest request = TestUtils.createIncomingRequest().build();
        return new DriverRequest(request, driver, false);
    }
}

