/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.util.Properties;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;
import org.esigate.HttpErrorPage;
import org.esigate.cache.CacheAdapter;
import org.esigate.events.EventManager;
import org.esigate.events.impl.FetchEvent;
import org.esigate.http.OutgoingRequestContext;

public class ProxyingHttpClientBuilder
extends CachingHttpClientBuilder {
    private Properties properties;
    private EventManager eventManager;
    private boolean useCache = true;

    protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
        ClientExecChain result = mainExec;
        result = this.addFetchEvent(result);
        if (this.useCache) {
            CacheAdapter cacheAdapter = new CacheAdapter();
            cacheAdapter.init(this.properties);
            result = cacheAdapter.wrapBackendHttpClient(result);
            result = super.decorateMainExec(result);
            result = cacheAdapter.wrapCachingHttpClient(result);
        }
        return result;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    private ClientExecChain addFetchEvent(final ClientExecChain wrapped) {
        return new ClientExecChain(){

            public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext httpClientContext, HttpExecutionAware execAware) {
                OutgoingRequestContext context = OutgoingRequestContext.adapt((HttpContext)httpClientContext);
                FetchEvent fetchEvent = new FetchEvent(context, request);
                ProxyingHttpClientBuilder.this.eventManager.fire(EventManager.EVENT_FETCH_PRE, fetchEvent);
                if (fetchEvent.isExit()) {
                    if (fetchEvent.getHttpResponse() == null) {
                        fetchEvent.setHttpResponse(HttpErrorPage.generateHttpResponse(500, "An extension stopped the processing of the request without providing a response"));
                    }
                } else {
                    try {
                        fetchEvent.setHttpResponse(wrapped.execute(route, request, (HttpClientContext)context, execAware));
                    }
                    catch (IOException e) {
                        fetchEvent.setHttpResponse(HttpErrorPage.generateHttpResponse(e));
                    }
                    catch (HttpException e) {
                        fetchEvent.setHttpResponse(HttpErrorPage.generateHttpResponse((Exception)((Object)e)));
                    }
                }
                ProxyingHttpClientBuilder.this.eventManager.fire(EventManager.EVENT_FETCH_POST, fetchEvent);
                return fetchEvent.getHttpResponse();
            }
        };
    }
}

