/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.impl.IndexedInstances;
import org.esigate.impl.UriMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverFactory {
    public static final String PROP_CONF_LOCATION = "esigate.config";
    private static IndexedInstances instances = new IndexedInstances(new HashMap<String, Driver>());
    private static final String DEFAULT_INSTANCE_NAME = "default";
    private static final Logger LOG = LoggerFactory.getLogger(DriverFactory.class);

    private DriverFactory() {
    }

    public static Collection<Driver> getInstances() {
        DriverFactory.ensureConfigured();
        return instances.getInstances().values();
    }

    public static void configure() {
        InputStream inputStream = null;
        InputStream extInputStream = null;
        try {
            URL configUrl = DriverFactory.getConfigUrl();
            if (configUrl == null) {
                throw new ConfigurationException("esigate.properties configuration file was not found in the classpath");
            }
            inputStream = configUrl.openStream();
            LOG.info("Scanning configuration {}", (Object)"/esigate-ext.properties");
            extInputStream = DriverFactory.class.getClassLoader().getResourceAsStream("/esigate-ext.properties");
            if (extInputStream == null) {
                LOG.info("Scanning configuration {}", (Object)"/driver-ext.properties");
                extInputStream = DriverFactory.class.getResourceAsStream("/driver-ext.properties");
            }
            if (extInputStream == null) {
                LOG.info("Scanning configuration /{}/{}", (Object)DriverFactory.class.getPackage().getName().replace(".", "/"), (Object)"driver-ext.properties");
                extInputStream = DriverFactory.class.getResourceAsStream("driver-ext.properties");
            }
            Properties merged = new Properties();
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                merged.putAll((Map<?, ?>)props);
            }
            if (extInputStream != null) {
                Properties extProps = new Properties();
                extProps.load(extInputStream);
                merged.putAll((Map<?, ?>)extProps);
            }
            DriverFactory.configure(merged);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error loading configuration", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (extInputStream != null) {
                    extInputStream.close();
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("failed to close stream", e);
            }
        }
    }

    public static void configure(Properties props) {
        Properties defaultProperties = new Properties();
        HashMap<String, Properties> driversProps = new HashMap<String, Properties>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            String value = props.getProperty(propertyName);
            int idx = propertyName.lastIndexOf(46);
            if (idx < 0) {
                defaultProperties.put(propertyName, value);
                continue;
            }
            String prefix = propertyName.substring(0, idx);
            String name = propertyName.substring(idx + 1);
            Properties driverProperties = (Properties)driversProps.get(prefix);
            if (driverProperties == null) {
                driverProperties = new Properties();
                driversProps.put(prefix, driverProperties);
            }
            driverProperties.put(name, value);
        }
        HashMap<String, Driver> newInstances = new HashMap<String, Driver>();
        for (Map.Entry entry : driversProps.entrySet()) {
            String name = (String)entry.getKey();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)defaultProperties);
            properties.putAll((Map<?, ?>)((Map)entry.getValue()));
            newInstances.put(name, DriverFactory.createDriver(name, properties));
        }
        if (newInstances.get(DEFAULT_INSTANCE_NAME) == null && Parameters.REMOTE_URL_BASE.getValue(defaultProperties) != null) {
            newInstances.put(DEFAULT_INSTANCE_NAME, DriverFactory.createDriver(DEFAULT_INSTANCE_NAME, defaultProperties));
        }
        instances = new IndexedInstances(newInstances);
    }

    private static Driver createDriver(String name, Properties properties) {
        Driver.DriverBuilder builder = Driver.builder().setName(name).setProperties(properties);
        return builder.build();
    }

    public static void configure(String name, Properties props) {
        DriverFactory.put(name, DriverFactory.createDriver(name, props));
    }

    public static Driver getInstance(String instanceName) {
        if (instanceName == null) {
            instanceName = DEFAULT_INSTANCE_NAME;
        }
        if (instances.getInstances().isEmpty()) {
            throw new ConfigurationException("Driver has not been configured and driver.properties file was not found");
        }
        Driver instance = instances.getInstances().get(instanceName);
        if (instance == null) {
            throw new ConfigurationException("No configuration properties found for factory : " + instanceName);
        }
        return instance;
    }

    public static Pair<Driver, UriMapping> getInstanceFor(String scheme, String host, String url) throws HttpErrorPage {
        for (UriMapping mapping : instances.getUrimappings().keySet()) {
            if (!mapping.matches(scheme, host, url)) continue;
            return new ImmutablePair((Object)DriverFactory.getInstance(instances.getUrimappings().get(mapping)), (Object)mapping);
        }
        throw new HttpErrorPage(404, "Not found", "No mapping defined for this url.");
    }

    public static Driver getInstance() {
        return DriverFactory.getInstance(DEFAULT_INSTANCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(String instanceName, Driver instance) {
        HashMap<String, Driver> newInstances = new HashMap<String, Driver>();
        IndexedInstances indexedInstances = instances;
        synchronized (indexedInstances) {
            Set<String> keys = instances.getInstances().keySet();
            for (String key : keys) {
                newInstances.put(key, instances.getInstances().get(key));
            }
        }
        newInstances.put(instanceName, instance);
        instances = new IndexedInstances(newInstances);
    }

    public static void ensureConfigured() {
        if (instances.getInstances().isEmpty()) {
            DriverFactory.configure();
        }
    }

    public static URL getConfigUrl() {
        URL configUrl = null;
        String envPath = System.getProperty(PROP_CONF_LOCATION);
        if (envPath != null) {
            try {
                LOG.info("Scanning configuration {}", (Object)envPath);
                configUrl = new File(envPath).toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.error("Can't read file {} (from -Desigate.config)", (Object)envPath, (Object)e);
            }
        }
        if (configUrl == null) {
            LOG.info("Scanning configuration {}", (Object)"/esigate.properties");
            configUrl = DriverFactory.class.getResource("/esigate.properties");
        }
        if (configUrl == null) {
            LOG.info("Scanning configuration /{}/{}", (Object)DriverFactory.class.getPackage().getName().replace(".", "/"), (Object)"driver.properties");
            configUrl = DriverFactory.class.getResource("driver.properties");
        }
        if (configUrl == null) {
            LOG.info("Scanning configuration {}", (Object)"/net/webassembletool/driver.properties");
            configUrl = DriverFactory.class.getResource("/net/webassembletool/driver.properties");
        }
        return configUrl;
    }

    static {
        String version = (String)StringUtils.defaultIfBlank((CharSequence)DriverFactory.class.getPackage().getSpecificationVersion(), (CharSequence)"development version");
        String rev = (String)StringUtils.defaultIfBlank((CharSequence)DriverFactory.class.getPackage().getImplementationVersion(), (CharSequence)"unknown");
        LOG.info("Starting esigate {} rev. {}", (Object)version, (Object)rev);
    }
}

