/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import org.esigate.impl.DriverRequest;
import org.esigate.util.UriUtils;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    private static String buildQueryString(DriverRequest originalRequest, boolean proxy) {
        StringBuilder queryString = new StringBuilder(256);
        String charset = originalRequest.getCharacterEncoding();
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        String originalQuerystring = UriUtils.getRawQuery(originalRequest.getRequestLine().getUri());
        if (proxy && originalQuerystring != null) {
            String jsessionid = null;
            jsessionid = originalRequest.getOriginalRequest().getSessionId();
            if (jsessionid != null) {
                originalQuerystring = UriUtils.removeSessionId(jsessionid, originalQuerystring);
            }
            queryString.append(originalQuerystring);
        }
        return queryString.toString();
    }

    private static String concatUrl(String baseUrl, String relUrl) {
        StringBuilder url = new StringBuilder(256);
        if (baseUrl != null && relUrl != null && (baseUrl.endsWith("/") || baseUrl.endsWith("\\")) && relUrl.startsWith("/")) {
            url.append(baseUrl.substring(0, baseUrl.length() - 1)).append(relUrl);
        } else {
            url.append(baseUrl).append(relUrl);
        }
        return url.toString();
    }

    public static String getHttpUrlWithQueryString(String url, DriverRequest originalRequest, boolean proxy) {
        String queryString;
        String baseUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://") && (baseUrl = originalRequest.getBaseUrl().toString()) != null) {
            url = ResourceUtils.concatUrl(baseUrl, url);
        }
        if ((queryString = ResourceUtils.buildQueryString(originalRequest, proxy)).length() == 0) {
            return url;
        }
        return url + "?" + queryString;
    }
}

