/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.RequestExecutor;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.cookie.CookieManager;
import org.esigate.events.EventManager;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.extension.ExtensionFactory;
import org.esigate.http.BasicCloseableHttpResponse;
import org.esigate.http.ContentTypeHelper;
import org.esigate.http.HeaderManager;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.IncomingRequest;
import org.esigate.http.OutgoingRequest;
import org.esigate.http.OutgoingRequestContext;
import org.esigate.http.ProxyingHttpClientBuilder;
import org.esigate.http.RedirectStrategy;
import org.esigate.http.RequestCookieStore;
import org.esigate.http.UnsupportedHttpMethodException;
import org.esigate.impl.DriverRequest;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientRequestExecutor
implements RequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientRequestExecutor.class);
    private static final Set<String> SIMPLE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE", "DELETE")));
    private static final Set<String> ENTITY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK")));
    private boolean preserveHost;
    private CookieManager cookieManager;
    private HttpClient httpClient;
    private EventManager eventManager = null;
    private HeaderManager headerManager;
    private int connectTimeout;
    private int socketTimeout;
    private HttpHost firstBaseUrlHost;

    private static HttpClient buildHttpClient(Properties properties, EventManager eventManager, HttpClientConnectionManager connectionManager) {
        HttpHost proxyHost = null;
        UsernamePasswordCredentials proxyCredentials = null;
        String proxyHostParameter = Parameters.PROXY_HOST.getValueString(properties);
        if (proxyHostParameter != null) {
            int proxyPort = Parameters.PROXY_PORT.getValueInt(properties);
            proxyHost = new HttpHost(proxyHostParameter, proxyPort);
            String proxyUser = Parameters.PROXY_USER.getValueString(properties);
            if (proxyUser != null) {
                String proxyPassword = Parameters.PROXY_PASSWORD.getValueString(properties);
                proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            }
        }
        ProxyingHttpClientBuilder httpClientBuilder = new ProxyingHttpClientBuilder();
        httpClientBuilder.setProperties(properties);
        httpClientBuilder.setMaxConnPerRoute(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        httpClientBuilder.setMaxConnTotal(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        httpClientBuilder.setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy());
        if (proxyHost != null) {
            httpClientBuilder.setProxy(proxyHost);
            if (proxyCredentials != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)proxyCredentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        boolean useCache = Parameters.USE_CACHE.getValueBoolean(properties);
        httpClientBuilder.setUseCache(Parameters.USE_CACHE.getValueBoolean(properties));
        if (useCache) {
            httpClientBuilder.setHttpCacheStorage(CacheConfigHelper.createCacheStorage(properties));
            httpClientBuilder.setCacheConfig(CacheConfigHelper.createCacheConfig(properties));
        }
        httpClientBuilder.setEventManager(eventManager);
        if (connectionManager != null) {
            httpClientBuilder.setConnectionManager(connectionManager);
        }
        return httpClientBuilder.build();
    }

    public static HttpClientHelperBuilder builder() {
        return new HttpClientHelperBuilder();
    }

    private HttpClientRequestExecutor() {
    }

    public OutgoingRequest createHttpRequest(DriverRequest originalRequest, String uri, boolean proxy) {
        HttpHost physicalHost = UriUtils.extractHost(uri);
        if (!originalRequest.isExternal()) {
            if (this.preserveHost) {
                HttpHost virtualHost = HttpRequestHelper.getHost((HttpRequest)originalRequest);
                uri = UriUtils.rewriteURI(uri, virtualHost);
            } else {
                uri = UriUtils.rewriteURI(uri, this.firstBaseUrlHost);
            }
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(this.connectTimeout);
        builder.setSocketTimeout(this.socketTimeout);
        builder.setCircularRedirectsAllowed(true);
        builder.setCookieSpec("compatibility");
        builder.setRedirectsEnabled(!proxy);
        RequestConfig config = builder.build();
        OutgoingRequestContext context = new OutgoingRequestContext();
        String method = proxy ? originalRequest.getRequestLine().getMethod().toUpperCase() : "GET";
        OutgoingRequest httpRequest = new OutgoingRequest(method, uri, originalRequest.getProtocolVersion(), originalRequest, config, context);
        if (ENTITY_METHODS.contains(method)) {
            httpRequest.setEntity(originalRequest.getEntity());
        } else if (!SIMPLE_METHODS.contains(method)) {
            throw new UnsupportedHttpMethodException(method + " " + uri);
        }
        this.headerManager.copyHeaders(originalRequest, httpRequest);
        context.setPhysicalHost(physicalHost);
        context.setOutgoingRequest(httpRequest);
        context.setProxy(proxy);
        return httpRequest;
    }

    @Override
    public CloseableHttpResponse execute(OutgoingRequest httpRequest) {
        OutgoingRequestContext context = httpRequest.getContext();
        IncomingRequest originalRequest = httpRequest.getOriginalRequest().getOriginalRequest();
        if (this.cookieManager != null) {
            RequestCookieStore cookieStore = new RequestCookieStore(this.cookieManager, httpRequest.getOriginalRequest());
            context.setCookieStore(cookieStore);
        }
        FragmentEvent event = new FragmentEvent(originalRequest, httpRequest, context);
        this.eventManager.fire(EventManager.EVENT_FRAGMENT_PRE, event);
        if (!event.isExit()) {
            if (event.getHttpResponse() == null) {
                if (httpRequest.containsHeader("Expect")) {
                    event.setHttpResponse(HttpErrorPage.generateHttpResponse(417, "'Expect' request header is not supported"));
                } else {
                    CloseableHttpResponse result;
                    try {
                        HttpHost physicalHost = context.getPhysicalHost();
                        HttpResponse response = this.httpClient.execute(physicalHost, (HttpRequest)httpRequest, (HttpContext)context);
                        result = new BasicHttpResponse(response.getStatusLine());
                        this.headerManager.copyHeaders((HttpRequest)httpRequest, (HttpEntityEnclosingRequest)originalRequest, response, (HttpResponse)result);
                        result.setEntity(response.getEntity());
                    }
                    catch (IOException e) {
                        result = HttpErrorPage.generateHttpResponse(e);
                        LOG.warn(httpRequest.getRequestLine() + " -> " + result.getStatusLine().toString());
                    }
                    event.setHttpResponse(BasicCloseableHttpResponse.adapt((HttpResponse)result));
                }
            }
            this.eventManager.fire(EventManager.EVENT_FRAGMENT_POST, event);
        }
        return event.getHttpResponse();
    }

    @Override
    public CloseableHttpResponse createAndExecuteRequest(DriverRequest originalRequest, String targetUrl, boolean proxy) throws HttpErrorPage {
        OutgoingRequest httpRequest = this.createHttpRequest(originalRequest, targetUrl, proxy);
        CloseableHttpResponse httpResponse = this.execute(httpRequest);
        if (httpResponse == null) {
            throw new HttpErrorPage(500, "Request was cancelled by server", "Request was cancelled by server");
        }
        if (HttpResponseUtils.isError((HttpResponse)httpResponse)) {
            throw new HttpErrorPage(httpResponse);
        }
        return httpResponse;
    }

    public static final class HttpClientHelperBuilder
    implements RequestExecutor.RequestExecutorBuilder {
        private EventManager eventManager;
        private Properties properties;
        private Driver driver;
        private HttpClientConnectionManager connectionManager;
        private CookieManager cookieManager;

        @Override
        public HttpClientHelperBuilder setDriver(Driver driver) {
            this.driver = driver;
            return this;
        }

        @Override
        public HttpClientHelperBuilder setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public HttpClientRequestExecutor build() {
            if (this.eventManager == null) {
                throw new ConfigurationException("eventManager is mandatory");
            }
            if (this.driver == null) {
                throw new ConfigurationException("driver is mandatory");
            }
            if (this.properties == null) {
                throw new ConfigurationException("properties is mandatory");
            }
            HttpClientRequestExecutor httpClientHelper = new HttpClientRequestExecutor();
            httpClientHelper.eventManager = this.eventManager;
            httpClientHelper.preserveHost = Parameters.PRESERVE_HOST.getValueBoolean(this.properties);
            httpClientHelper.headerManager = new HeaderManager();
            if (this.cookieManager == null) {
                this.cookieManager = (CookieManager)ExtensionFactory.getExtension(this.properties, Parameters.COOKIE_MANAGER, this.driver);
            }
            httpClientHelper.cookieManager = this.cookieManager;
            httpClientHelper.connectTimeout = Parameters.CONNECT_TIMEOUT.getValueInt(this.properties);
            httpClientHelper.socketTimeout = Parameters.SOCKET_TIMEOUT.getValueInt(this.properties);
            httpClientHelper.httpClient = HttpClientRequestExecutor.buildHttpClient(this.properties, this.eventManager, this.connectionManager);
            String firstBaseURL = Parameters.REMOTE_URL_BASE.getValueArray(this.properties)[0];
            httpClientHelper.firstBaseUrlHost = UriUtils.extractHost(firstBaseURL);
            return httpClientHelper;
        }

        @Override
        public HttpClientHelperBuilder setContentTypeHelper(ContentTypeHelper contentTypeHelper) {
            return this;
        }

        public HttpClientHelperBuilder setConnectionManager(HttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public HttpClientHelperBuilder setEventManager(EventManager eventManager) {
            this.eventManager = eventManager;
            return this;
        }

        public HttpClientHelperBuilder setCookieManager(CookieManager cookieManager) {
            this.cookieManager = cookieManager;
            return this;
        }
    }
}

