/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.extension.Extension;
import org.esigate.util.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReloadOnChange
implements Extension {
    private static final long DEFAULT_RELOAD_DELAY = 5000L;
    public static final Parameter CONFIG_RELOAD_DELAY = new Parameter("configReloadDelay", String.valueOf(5000L));
    private static final int SPEED_LIMIT = 100;
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigReloadOnChange.class);
    private static File configuration = null;
    private static long lastModified = -1L;
    private static long delay = 5000L;
    private static boolean stop = false;
    private static Thread fileWatcher = new Thread(){

        @Override
        public void run() {
            while (!stop) {
                if (configuration != null && configuration.exists() && configuration.lastModified() != lastModified) {
                    lastModified = configuration.lastModified();
                    LOG.warn("Configuration file changed : reloading.");
                    DriverFactory.configure();
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    stop = true;
                    LOG.warn("Watching interrupted.");
                }
            }
            LOG.info("Stopped watching {}.", (Object)configuration.getAbsoluteFile());
        }
    };

    @Override
    public void init(Driver driver, Properties properties) {
        if (configuration == null) {
            LOG.warn("Cannot reload configuration from classpath. Please use -Desigate.config");
            return;
        }
        try {
            long configDelay = CONFIG_RELOAD_DELAY.getValueLong(properties);
            if (configDelay < 100L) {
                delay = 100L;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to convert {}={} as number", (Object)CONFIG_RELOAD_DELAY.getName(), (Object)CONFIG_RELOAD_DELAY.getValueString(properties));
        }
        LOG.info("Will reload configuration every {}ms if {} is modified", (Object)delay, (Object)configuration.getAbsoluteFile());
    }

    static {
        String envPath = System.getProperty("esigate.config");
        if (envPath != null) {
            configuration = new File(envPath);
        } else {
            URL configUrl = DriverFactory.getConfigUrl();
            if (configUrl != null && "file".equalsIgnoreCase(configUrl.getProtocol())) {
                try {
                    configuration = new File(configUrl.toURI());
                }
                catch (URISyntaxException e) {
                    LOG.error("Unable to access configuration file", (Throwable)e);
                }
            }
        }
        if (configuration != null && configuration.exists()) {
            lastModified = configuration.lastModified();
        }
        fileWatcher.start();
    }
}

