/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.esigate.ConfigurationException;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.Renderer;
import org.esigate.RequestExecutor;
import org.esigate.events.EventManager;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.events.impl.RenderEvent;
import org.esigate.extension.ExtensionFactory;
import org.esigate.http.BasicCloseableHttpResponse;
import org.esigate.http.ContentTypeHelper;
import org.esigate.http.HttpClientRequestExecutor;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.IncomingRequest;
import org.esigate.http.ResourceUtils;
import org.esigate.impl.DriverRequest;
import org.esigate.impl.UrlRewriter;
import org.esigate.util.UriUtils;
import org.esigate.vars.VariablesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Driver {
    private static final String CACHE_RESPONSE_PREFIX = "response_";
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    private DriverConfiguration config;
    private EventManager eventManager;
    private RequestExecutor requestExecutor;
    private ContentTypeHelper contentTypeHelper;
    private UrlRewriter urlRewriter;

    protected Driver() {
    }

    public static DriverBuilder builder() {
        return new DriverBuilder();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public CloseableHttpResponse render(String pageUrl, IncomingRequest incomingRequest, Renderer ... renderers) throws IOException, HttpErrorPage {
        boolean external = UriUtils.isAbsolute(pageUrl);
        DriverRequest driverRequest = new DriverRequest(incomingRequest, this, external);
        String resultingPageUrl = VariablesResolver.replaceAllVariables(pageUrl, driverRequest);
        CloseableHttpResponse response = null;
        String currentValue = null;
        boolean cacheable = "GET".equalsIgnoreCase(incomingRequest.getRequestLine().getMethod());
        if (cacheable) {
            currentValue = (String)incomingRequest.getAttribute(resultingPageUrl);
            response = (CloseableHttpResponse)incomingRequest.getAttribute(CACHE_RESPONSE_PREFIX + resultingPageUrl);
        }
        if (currentValue == null) {
            String targetUrl = ResourceUtils.getHttpUrlWithQueryString(resultingPageUrl, driverRequest, false);
            response = this.requestExecutor.createAndExecuteRequest(driverRequest, targetUrl, false);
            currentValue = HttpResponseUtils.toString((HttpResponse)response, this.eventManager);
            if (cacheable) {
                incomingRequest.setAttribute(resultingPageUrl, currentValue);
                incomingRequest.setAttribute(CACHE_RESPONSE_PREFIX + resultingPageUrl, response);
            }
        }
        this.logAction("render", pageUrl, renderers);
        currentValue = this.performRendering(pageUrl, driverRequest, response, currentValue, renderers);
        response.setEntity((HttpEntity)new StringEntity(currentValue, HttpResponseUtils.getContentType(response)));
        return response;
    }

    private void logAction(String action, String onUrl, Renderer[] renderers) {
        if (LOG.isInfoEnabled()) {
            ArrayList<String> rendererNames = new ArrayList<String>(renderers.length);
            for (Renderer renderer : renderers) {
                rendererNames.add(renderer.getClass().getName());
            }
            LOG.info("{} provider={} page= {} renderers={}", new Object[]{action, this.config.getInstanceName(), onUrl, rendererNames});
        }
    }

    public CloseableHttpResponse proxy(String relUrl, IncomingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage {
        boolean external = UriUtils.isAbsolute(relUrl);
        DriverRequest driverRequest = new DriverRequest(request, this, external);
        driverRequest.setCharacterEncoding(this.config.getUriEncoding());
        boolean postProxyPerformed = false;
        ProxyEvent e = new ProxyEvent(request);
        try {
            this.eventManager.fire(EventManager.EVENT_PROXY_PRE, e);
            if (e.isExit()) {
                CloseableHttpResponse closeableHttpResponse = e.getResponse();
                return closeableHttpResponse;
            }
            this.logAction("proxy", relUrl, renderers);
            String url = ResourceUtils.getHttpUrlWithQueryString(relUrl, driverRequest, true);
            e.setResponse(this.requestExecutor.createAndExecuteRequest(driverRequest, url, true));
            e.setResponse(this.performRendering(relUrl, driverRequest, e.getResponse(), renderers));
            postProxyPerformed = true;
            this.eventManager.fire(EventManager.EVENT_PROXY_POST, e);
            CloseableHttpResponse closeableHttpResponse = e.getResponse();
            return closeableHttpResponse;
        }
        catch (HttpErrorPage errorPage) {
            e.setErrorPage(errorPage);
            e.setErrorPage(new HttpErrorPage(this.performRendering(relUrl, driverRequest, e.getErrorPage().getHttpResponse(), renderers)));
            postProxyPerformed = true;
            this.eventManager.fire(EventManager.EVENT_PROXY_POST, e);
            throw e.getErrorPage();
        }
        finally {
            if (!postProxyPerformed) {
                this.eventManager.fire(EventManager.EVENT_PROXY_POST, e);
            }
        }
    }

    private CloseableHttpResponse performRendering(String pageUrl, DriverRequest originalRequest, CloseableHttpResponse response, Renderer[] renderers) throws HttpErrorPage, IOException {
        if (!this.contentTypeHelper.isTextContentType((HttpResponse)response)) {
            LOG.debug("'{}' is binary on no transformation to apply: was forwarded without modification.", (Object)pageUrl);
            return response;
        }
        LOG.debug("'{}' is text : will apply renderers.", (Object)pageUrl);
        String currentValue = HttpResponseUtils.toString((HttpResponse)response, this.eventManager);
        currentValue = this.performRendering(pageUrl, originalRequest, response, currentValue, renderers);
        StringEntity transformedHttpEntity = new StringEntity(currentValue, ContentType.get((HttpEntity)response.getEntity()));
        CloseableHttpResponse transformedResponse = BasicCloseableHttpResponse.adapt((HttpResponse)new BasicHttpResponse(response.getStatusLine()));
        transformedResponse.setHeaders(response.getAllHeaders());
        transformedResponse.setEntity((HttpEntity)transformedHttpEntity);
        return transformedResponse;
    }

    private String performRendering(String pageUrl, DriverRequest originalRequest, CloseableHttpResponse response, String body, Renderer[] renderers) throws IOException, HttpErrorPage {
        RenderEvent renderEvent = new RenderEvent(pageUrl, originalRequest, response);
        renderEvent.getRenderers().addAll(Arrays.asList(renderers));
        String currentBody = body;
        this.eventManager.fire(EventManager.EVENT_RENDER_PRE, renderEvent);
        for (Renderer renderer : renderEvent.getRenderers()) {
            StringBuilderWriter stringWriter = new StringBuilderWriter(1024);
            renderer.render(originalRequest, currentBody, (Writer)stringWriter);
            stringWriter.close();
            currentBody = stringWriter.toString();
        }
        this.eventManager.fire(EventManager.EVENT_RENDER_POST, renderEvent);
        return currentBody;
    }

    public DriverConfiguration getConfiguration() {
        return this.config;
    }

    public RequestExecutor getRequestExecutor() {
        return this.requestExecutor;
    }

    public String toString() {
        return "driver:" + this.config.getInstanceName();
    }

    public ContentTypeHelper getContentTypeHelper() {
        return this.contentTypeHelper;
    }

    public UrlRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public static class DriverBuilder {
        private Driver driver = new Driver();
        private String name;
        private Properties properties;
        private RequestExecutor.RequestExecutorBuilder requestExecutorBuilder;

        public Driver build() {
            if (this.name == null) {
                throw new ConfigurationException("name is mandatory");
            }
            if (this.properties == null) {
                throw new ConfigurationException("properties is mandatory");
            }
            if (this.requestExecutorBuilder == null) {
                this.requestExecutorBuilder = HttpClientRequestExecutor.builder();
            }
            this.driver.eventManager = new EventManager(this.name);
            this.driver.config = new DriverConfiguration(this.name, this.properties);
            this.driver.contentTypeHelper = new ContentTypeHelper(this.properties);
            ExtensionFactory.getExtensions(this.properties, Parameters.EXTENSIONS, this.driver);
            this.driver.requestExecutor = this.requestExecutorBuilder.setDriver(this.driver).setEventManager(this.driver.eventManager).setProperties(this.properties).setContentTypeHelper(this.driver.contentTypeHelper).build();
            this.driver.urlRewriter = new UrlRewriter(this.properties);
            return this.driver;
        }

        public DriverBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DriverBuilder setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public DriverBuilder setRequestExecutorBuilder(RequestExecutor.RequestExecutorBuilder requestExecutorBuilder) {
            this.requestExecutorBuilder = requestExecutorBuilder;
            return this;
        }
    }
}

