/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;

public class UriUtils {
    private UriUtils() {
    }

    public static URI createURI(String scheme, String host, int port, String path, String query, String fragment) {
        try {
            StringBuilder buffer = new StringBuilder();
            if (host != null) {
                if (scheme != null) {
                    buffer.append(scheme);
                    buffer.append("://");
                }
                buffer.append(host);
                if (port > 0) {
                    buffer.append(':');
                    buffer.append(port);
                }
            }
            if (path == null || !path.startsWith("/")) {
                buffer.append('/');
            }
            if (path != null) {
                buffer.append(path);
            }
            if (query != null) {
                buffer.append('?');
                buffer.append(query);
            }
            if (fragment != null) {
                buffer.append('#');
                buffer.append(fragment);
            }
            return new URI(buffer.toString());
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static URI rewriteURI(URI uri, HttpHost target) {
        try {
            return URIUtils.rewriteURI((URI)uri, (HttpHost)target);
        }
        catch (URISyntaxException e) {
            throw new InvalidUriException(e);
        }
    }

    public static URI resolve(URI baseURI, String reference) {
        return URIUtils.resolve((URI)baseURI, (String)reference);
    }

    public static String extractHostName(URI uri) {
        return uri.getHost();
    }

    public static String extractHostName(String uri) {
        return UriUtils.extractHostName(UriUtils.createUri(uri));
    }

    public static HttpHost extractHost(String uri) {
        return URIUtils.extractHost((URI)UriUtils.createUri(uri));
    }

    public static URI createUri(String uri) {
        return URI.create(uri);
    }

    public static URI resolve(String baseURI, String reference) {
        return UriUtils.resolve(UriUtils.createUri(baseURI), reference);
    }

    public static Object rewriteURI(String uri, HttpHost targetHost) {
        return UriUtils.rewriteURI(UriUtils.createUri(uri), targetHost);
    }

    public static final String removeSessionId(String sessionId, String page) {
        String regexp = ";?jsessionid=" + Pattern.quote(sessionId);
        return page.replaceAll(regexp, "");
    }

    public static final String extractScheme(String uri) {
        return UriUtils.createUri(uri).getScheme();
    }

    public static final String translateUrl(String sourceUrl, String sourceContext, String targetContext) throws MalformedURLException {
        String commonSuffix = StringUtils.reverse((String)StringUtils.getCommonPrefix((String[])new String[]{StringUtils.reverse((String)sourceContext), StringUtils.reverse((String)targetContext)}));
        String sourcePrefix = StringUtils.removeEnd((String)sourceContext, (String)commonSuffix);
        HttpHost sourceHost = UriUtils.extractHost(sourcePrefix);
        String targetPrefix = StringUtils.removeEnd((String)targetContext, (String)commonSuffix);
        String absoluteSourceUrl = UriUtils.resolve(sourceContext, sourceUrl).toString();
        if (UriUtils.extractHost(absoluteSourceUrl).equals((Object)sourceHost) && absoluteSourceUrl.startsWith(sourcePrefix)) {
            return targetPrefix + StringUtils.removeStart((String)absoluteSourceUrl, (String)sourcePrefix);
        }
        return absoluteSourceUrl;
    }

    public static class InvalidUriException
    extends RuntimeException {
        private static final long serialVersionUID = 7013885420191182730L;

        private InvalidUriException(URISyntaxException cause) {
            super(cause);
        }
    }
}

