/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test.driver;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpRequestExecutor;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.Renderer;
import org.esigate.cookie.CookieManager;
import org.esigate.events.EventManager;
import org.esigate.extension.ExtensionFactory;
import org.esigate.http.HttpClientHelper;
import org.esigate.test.TestUtils;
import org.esigate.test.driver.MockHttpClient;
import org.esigate.test.http.HttpRequestBuilder;
import org.esigate.test.http.HttpResponseBuilder;

public abstract class AbstractDriverTestCase
extends TestCase {
    protected static Driver createMockDriver(Properties properties, HttpRequestExecutor requestExecutor) {
        MockHttpClient mockHttpClient = new MockHttpClient();
        mockHttpClient.setHttpResponseExecutor(requestExecutor);
        return AbstractDriverTestCase.createMockDriver(properties, (HttpClient)mockHttpClient, "tested");
    }

    private static Driver createMockDriver(Properties properties, HttpClient httpClient, String name) {
        CookieManager cookieManager = (CookieManager)ExtensionFactory.getExtension(properties, Parameters.COOKIE_MANAGER, null);
        HttpClientHelper httpClientHelper = new HttpClientHelper(new EventManager(), cookieManager, httpClient, properties);
        Driver driver = new Driver(name, properties, httpClientHelper);
        DriverFactory.put(name, driver);
        return driver;
    }

    protected static Driver createMockDriver(Properties properties, HttpResponse response) {
        MockHttpClient mockHttpClient = new MockHttpClient();
        mockHttpClient.setResponse(response);
        return AbstractDriverTestCase.createMockDriver(properties, (HttpClient)mockHttpClient, "tested");
    }

    public static HttpResponseBuilder createHttpResponse() {
        return new HttpResponseBuilder();
    }

    public static HttpRequestBuilder createHttpRequest() {
        return new HttpRequestBuilder();
    }

    public static HttpResponse driverProxy(Driver d, HttpEntityEnclosingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage, URISyntaxException {
        String uri = request.getRequestLine().getUri();
        d.proxy(new URI(uri).getPath(), request, renderers);
        return TestUtils.getResponse(request);
    }
}

