/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.AggregateRenderer;
import org.esigate.esi.EsiRenderer;
import org.esigate.impl.UriMapping;
import org.esigate.servlet.HttpServletMediator;
import org.esigate.servlet.impl.DriverSelector;
import org.esigate.servlet.impl.RequestUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServlet.class);
    private DriverSelector driverSelector = new DriverSelector();

    public DriverSelector getDriverSelector() {
        return this.driverSelector;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletMediator mediator = new HttpServletMediator(request, response, this.getServletContext());
        try {
            Pair<Driver, UriMapping> dm = this.driverSelector.selectProvider(request);
            String relUrl = RequestUrl.getRelativeUrl(request, (UriMapping)dm.getRight());
            LOG.debug("Proxying {}", (Object)relUrl);
            ((Driver)dm.getLeft()).proxy(relUrl, mediator.getHttpRequest(), new AggregateRenderer(), new EsiRenderer());
        }
        catch (HttpErrorPage e) {
            mediator.sendResponse(e.getHttpResponse());
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.driverSelector.setWebXmlProvider(config.getInitParameter("provider"));
        this.driverSelector.setWebXmlProviders(config.getInitParameter("providers"));
        this.driverSelector.setUseMappings("true".equalsIgnoreCase(config.getInitParameter("useMappings")));
        DriverFactory.ensureConfigured();
    }
}

