/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.renderers;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.Renderer;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFixupRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFixupRenderer.class);
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final char SLASH = '/';
    private static final Pattern URL_PATTERN = Pattern.compile("<([^\\!][^>]+)(src|href|action|background)\\s*=\\s*('[^<']*'|\"[^<\"]*\")([^>]*)>", 2);
    private String contextAdd = null;
    private String contextRemove = null;
    private String pagePath = null;
    private String fileName = null;
    private String server = null;
    private String baseUrl;
    private String replacementUrl;
    private final boolean fixRelativeUrls;
    private final int mode;

    public ResourceFixupRenderer(String baseUrl, String visibleBaseUrl, String pageFullPath, int mode) {
        this(baseUrl, visibleBaseUrl, pageFullPath, mode, true);
    }

    public ResourceFixupRenderer(String baseUrl, String visibleBaseUrl, String pageFullPath, int mode, boolean fixRelativeUrls) {
        int indexSlash;
        this.mode = mode;
        this.fixRelativeUrls = fixRelativeUrls;
        if (visibleBaseUrl != null && visibleBaseUrl.length() != 0) {
            this.baseUrl = this.removeLeadingSlash(baseUrl);
            this.replacementUrl = this.removeLeadingSlash(visibleBaseUrl);
        } else {
            this.baseUrl = null;
            this.replacementUrl = null;
        }
        String cleanBaseUrl = baseUrl;
        if (visibleBaseUrl != null) {
            cleanBaseUrl = visibleBaseUrl;
        }
        cleanBaseUrl = this.removeLeadingSlash(cleanBaseUrl);
        String cleanPageFullPath = pageFullPath;
        if (StringUtils.isNotEmpty((CharSequence)cleanPageFullPath) && cleanPageFullPath.charAt(0) == '/') {
            cleanPageFullPath = cleanPageFullPath.substring(1);
        }
        if (cleanPageFullPath.length() > 0 && cleanPageFullPath.charAt(cleanPageFullPath.length() - 1) != '/') {
            this.fileName = cleanPageFullPath.substring(cleanPageFullPath.lastIndexOf(47) + 1);
        }
        URI url = UriUtils.createUri(cleanBaseUrl + '/' + cleanPageFullPath);
        this.server = url.getScheme() + "://" + url.getHost();
        if (url.getPort() > -1) {
            this.server = this.server + ":" + url.getPort();
        }
        this.pagePath = url.getPath();
        if (this.pagePath != null && (indexSlash = this.pagePath.lastIndexOf(47)) >= 0) {
            this.pagePath = this.pagePath.substring(0, indexSlash);
        }
        if (baseUrl != null && !baseUrl.equals(visibleBaseUrl)) {
            this.contextRemove = UriUtils.createUri(baseUrl).getPath();
            this.contextAdd = UriUtils.createUri(visibleBaseUrl).getPath();
        }
    }

    private String removeLeadingSlash(String src) {
        int lastCharPosition = src.length() - 1;
        if (src.charAt(lastCharPosition) != '/') {
            return src;
        }
        return src.substring(0, lastCharPosition);
    }

    private String fixUrl(String urlParam) {
        String url = urlParam;
        if (url.length() == 0) {
            return url;
        }
        if (this.replacementUrl != null && url.startsWith(this.baseUrl)) {
            url = new StringBuffer(this.replacementUrl).append(url.substring(this.baseUrl.length())).toString();
            LOG.debug("fix absolute url: {} -> {} ", (Object)urlParam, (Object)url);
            return url;
        }
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//") || url.startsWith("#") || url.startsWith("javascript:") || url.startsWith("mailto:")) {
            LOG.debug("keeping absolute url: {}", (Object)url);
            return url;
        }
        if (url.charAt(0) == '/') {
            if (this.contextRemove != null && url.startsWith(this.contextRemove)) {
                url = url.substring(this.contextRemove.length());
                url = this.contextAdd + url;
            }
            if (this.mode == 0) {
                url = this.server + url;
            }
        } else if (this.fixRelativeUrls) {
            if (url.charAt(0) == '?' && this.fileName != null) {
                url = this.fileName + url;
            }
            url = this.mode == 0 ? this.server + this.pagePath + '/' + url : this.pagePath + '/' + url;
        }
        LOG.debug("url fixed: {} -> {}", (Object)urlParam, (Object)url);
        return url;
    }

    public void render(HttpEntityEnclosingRequest httpRequest, String src, Writer out) throws IOException {
        out.write(this.replace(src).toString());
    }

    CharSequence replace(CharSequence input) {
        StringBuffer result = new StringBuffer(input.length());
        Matcher m = URL_PATTERN.matcher(input);
        while (m.find()) {
            LOG.trace("found match: {}", (Object)m);
            String url = input.subSequence(m.start(3) + 1, m.end(3) - 1).toString();
            url = this.fixUrl(url);
            url = url.replaceAll("\\$", "\\\\\\$");
            StringBuffer tagReplacement = new StringBuffer("<$1$2=\"").append(url).append("\"");
            if (m.groupCount() > 3) {
                tagReplacement.append("$4");
            }
            tagReplacement.append('>');
            LOG.trace("replacement: {}", (Object)tagReplacement);
            m.appendReplacement(result, tagReplacement.toString());
        }
        m.appendTail(result);
        return result;
    }
}

