/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.parallelesi;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.esigate.HttpErrorPage;
import org.esigate.extension.parallelesi.BaseElement;
import org.esigate.extension.parallelesi.BaseElementType;
import org.esigate.extension.parallelesi.InlineCache;
import org.esigate.extension.parallelesi.Tag;
import org.esigate.parser.future.FutureElementType;
import org.esigate.parser.future.FutureParserContext;
import org.esigate.parser.future.StringBuilderFutureAppendable;
import org.esigate.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InlineElement
extends BaseElement {
    public static final FutureElementType TYPE = new BaseElementType("<esi:inline", "</esi:inline"){

        public InlineElement newInstance() {
            return new InlineElement();
        }
    };
    private String uri;
    private boolean fetchable;
    private StringBuilderFutureAppendable buf = new StringBuilderFutureAppendable();

    InlineElement() {
    }

    @Override
    protected void parseTag(Tag tag, FutureParserContext ctx) {
        this.uri = tag.getAttribute("name");
        this.fetchable = "yes".equalsIgnoreCase(tag.getAttribute("fetchable"));
    }

    @Override
    public void characters(Future<CharSequence> csq) throws IOException {
        this.buf.enqueueAppend(csq);
    }

    @Override
    public void onTagEnd(String tag, FutureParserContext ctx) throws IOException, HttpErrorPage {
        String originalUrl = UriUtils.createUri(ctx.getHttpRequest().getRequestLine().getUri()).getPath();
        try {
            InlineCache.storeFragment(this.uri, null, this.fetchable, originalUrl, this.buf.get().toString());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }
}

