/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private ResourceUtils() {
    }

    private static final String buildQueryString(HttpRequest originalRequest, boolean proxy) {
        try {
            Map<String, String> parameters;
            StringBuilder queryString = new StringBuilder();
            String charset = HttpRequestHelper.getCharacterEncoding(originalRequest);
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            String originalQuerystring = UriUtils.createUri(originalRequest.getRequestLine().getUri()).getRawQuery();
            if (proxy && originalQuerystring != null) {
                String jsessionid = null;
                ContainerRequestMediator mediator = HttpRequestHelper.getMediator(originalRequest);
                jsessionid = mediator.getSessionId();
                if (jsessionid != null) {
                    originalQuerystring = UriUtils.removeSessionId(jsessionid, originalQuerystring);
                }
                queryString.append(originalQuerystring);
            }
            if ((parameters = HttpRequestHelper.getParameters(originalRequest)) != null) {
                ResourceUtils.appendParameters(queryString, charset, parameters);
            }
            return queryString.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendParameters(StringBuilder buf, String charset, Map<String, String> params) throws UnsupportedEncodingException {
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (buf.length() > 0) {
                buf.append("&");
            }
            buf.append(URLEncoder.encode(param.getKey(), charset));
            buf.append("=");
            buf.append(URLEncoder.encode(param.getValue(), charset));
        }
    }

    private static final String concatUrl(String baseUrl, String relUrl) {
        StringBuilder url = new StringBuilder();
        if (baseUrl != null && relUrl != null && (baseUrl.endsWith("/") || baseUrl.endsWith("\\")) && relUrl.startsWith("/")) {
            url.append(baseUrl.substring(0, baseUrl.length() - 1)).append(relUrl);
        } else {
            url.append(baseUrl).append(relUrl);
        }
        return url.toString();
    }

    public static final String getHttpUrlWithQueryString(String url, HttpRequest originalRequest, boolean proxy) {
        String queryString;
        String baseUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://") && (baseUrl = HttpRequestHelper.getBaseUrl(originalRequest).toString()) != null) {
            url = ResourceUtils.concatUrl(baseUrl, url);
        }
        if ((queryString = ResourceUtils.buildQueryString(originalRequest, proxy)).length() == 0) {
            return url;
        }
        return url + "?" + queryString;
    }
}

