/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.EntityUtils;

public class HttpErrorPage
extends Exception {
    private static final long serialVersionUID = 1L;
    private final HttpResponse httpResponse;

    public HttpErrorPage(HttpResponse httpResponse) {
        super(httpResponse.getStatusLine().getStatusCode() + " " + httpResponse.getStatusLine().getReasonPhrase());
        this.httpResponse = httpResponse;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            ByteArrayEntity memoryEntity;
            try {
                byte[] content = EntityUtils.toByteArray((HttpEntity)httpEntity);
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(content, ContentType.get((HttpEntity)httpEntity));
                Header contentEncoding = httpEntity.getContentEncoding();
                if (contentEncoding != null) {
                    byteArrayEntity.setContentEncoding(contentEncoding);
                }
                memoryEntity = byteArrayEntity;
            }
            catch (IOException e) {
                StringWriter out = new StringWriter();
                e.printStackTrace(new PrintWriter(out));
                memoryEntity = new StringEntity(out.toString(), ContentType.getOrDefault((HttpEntity)httpEntity));
            }
            this.httpResponse.setEntity((HttpEntity)memoryEntity);
        }
    }

    public HttpErrorPage(int statusCode, String statusMessage, String content) {
        super(statusCode + " " + statusMessage);
        this.httpResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusMessage));
        try {
            this.httpResponse.setEntity((HttpEntity)new StringEntity(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpErrorPage(int statusCode, String statusMessage, Exception exception) {
        super(statusCode + " " + statusMessage, exception);
        this.httpResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusMessage));
        StringWriter out = new StringWriter();
        exception.printStackTrace(new PrintWriter(out));
        String content = out.toString();
        try {
            this.httpResponse.setEntity((HttpEntity)new StringEntity(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }
}

