/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.api.BaseUrlRetrieveStrategy;
import org.esigate.impl.UriMapping;
import org.esigate.url.IpHashBaseUrlRetrieveStrategy;
import org.esigate.url.RoundRobinBaseUrlRetrieveStrategy;
import org.esigate.url.SingleBaseUrlRetrieveStrategy;
import org.esigate.url.StickySessionBaseUrlRetrieveStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverConfiguration {
    private final String instanceName;
    private final String uriEncoding;
    private final boolean fixResources;
    private final String visibleBaseURL;
    private final int fixMode;
    private final Properties properties;
    private final boolean preserveHost;
    private final String filter;
    private final BaseUrlRetrieveStrategy baseUrlRetrieveStrategy;
    private final boolean isVisibleBaseURLEmpty;
    private final List<UriMapping> uriMappings;

    public DriverConfiguration(String instanceName, Properties props) {
        this.instanceName = instanceName;
        this.baseUrlRetrieveStrategy = this.getBaseUrlRetrieveSession(props);
        this.uriEncoding = Parameters.URI_ENCODING.getValueString(props);
        this.filter = Parameters.FILTER.getValueString(props);
        this.preserveHost = Parameters.PRESERVE_HOST.getValueBoolean(props);
        this.fixResources = Parameters.FIX_RESOURCES.getValueBoolean(props);
        this.visibleBaseURL = Parameters.VISIBLE_URL_BASE.getValueString(props);
        this.isVisibleBaseURLEmpty = StringUtils.isEmpty((CharSequence)this.visibleBaseURL);
        this.fixMode = "absolute".equalsIgnoreCase(Parameters.FIX_MODE.getValueString(props)) ? 0 : 1;
        this.uriMappings = DriverConfiguration.parseMappings(props);
        this.properties = props;
    }

    private static List<UriMapping> parseMappings(Properties props) {
        ArrayList<UriMapping> mappings = new ArrayList<UriMapping>();
        Collection<String> mappingsParam = Parameters.MAPPINGS.getValueList(props);
        for (String mappingParam : mappingsParam) {
            mappings.add(UriMapping.create(mappingParam));
        }
        return mappings;
    }

    private BaseUrlRetrieveStrategy getBaseUrlRetrieveSession(Properties props) {
        BaseUrlRetrieveStrategy urlStrategy = null;
        String baseURLs = Parameters.REMOTE_URL_BASE.getValueString(props);
        if (StringUtils.isEmpty((CharSequence)baseURLs)) {
            throw new ConfigurationException(Parameters.REMOTE_URL_BASE.name + " property cannot be empty for instance '" + this.instanceName + "'");
        }
        String[] urls = StringUtils.split((String)baseURLs, (String)",");
        if (1 == urls.length) {
            String baseURL = StringUtils.trimToEmpty((String)urls[0]);
            urlStrategy = new SingleBaseUrlRetrieveStrategy(baseURL);
        } else if (urls.length > 0) {
            String[] urlArr = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                String baseURL;
                urlArr[i] = baseURL = StringUtils.trimToEmpty((String)urls[i]);
            }
            String strategy = Parameters.REMOTE_URL_BASE_STRATEGY.getValueString(props);
            if ("roundrobin".equalsIgnoreCase(strategy)) {
                urlStrategy = new RoundRobinBaseUrlRetrieveStrategy(urlArr);
            } else if ("iphash".equalsIgnoreCase(strategy)) {
                urlStrategy = new IpHashBaseUrlRetrieveStrategy(urlArr);
            } else if ("stickysession".equalsIgnoreCase(strategy)) {
                urlStrategy = new StickySessionBaseUrlRetrieveStrategy(urlArr);
            } else {
                throw new ConfigurationException("No such BaseUrlRetrieveStrategy '" + strategy + "'");
            }
        }
        return urlStrategy;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getFixMode() {
        return this.fixMode;
    }

    public boolean isFixResources() {
        return this.fixResources;
    }

    public String getVisibleBaseURL(String currentBaseUrl) {
        return this.isVisibleBaseURLEmpty ? currentBaseUrl : this.visibleBaseURL;
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public BaseUrlRetrieveStrategy getBaseUrlRetrieveStrategy() {
        return this.baseUrlRetrieveStrategy;
    }

    public List<UriMapping> getUriMappings() {
        return this.uriMappings;
    }
}

