/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.parallelesi;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.extension.parallelesi.AttemptElement;
import org.esigate.extension.parallelesi.ChooseElement;
import org.esigate.extension.parallelesi.Comment;
import org.esigate.extension.parallelesi.CommentElement;
import org.esigate.extension.parallelesi.ExceptElement;
import org.esigate.extension.parallelesi.FragmentElement;
import org.esigate.extension.parallelesi.IncludeElement;
import org.esigate.extension.parallelesi.InlineElement;
import org.esigate.extension.parallelesi.OtherwiseElement;
import org.esigate.extension.parallelesi.RemoveElement;
import org.esigate.extension.parallelesi.ReplaceElement;
import org.esigate.extension.parallelesi.TryElement;
import org.esigate.extension.parallelesi.VarsElement;
import org.esigate.extension.parallelesi.WhenElement;
import org.esigate.parser.future.FutureAppendable;
import org.esigate.parser.future.FutureAppendableAdapter;
import org.esigate.parser.future.FutureParser;
import org.esigate.parser.future.StringBuilderFutureAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsiRenderer
implements Renderer,
FutureAppendable {
    private static final Logger LOG = LoggerFactory.getLogger(EsiRenderer.class);
    public static final String DATA_EXECUTOR = "executor";
    private static final Pattern PATTERN = Pattern.compile("(<esi:\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>)|(</esi:[^>]*>)");
    private static final Pattern PATTERN_COMMENTS = Pattern.compile("(<!--esi)|(-->)");
    private final FutureParser parser = new FutureParser(PATTERN, IncludeElement.TYPE, CommentElement.TYPE, RemoveElement.TYPE, VarsElement.TYPE, ChooseElement.TYPE, WhenElement.TYPE, OtherwiseElement.TYPE, TryElement.TYPE, AttemptElement.TYPE, ExceptElement.TYPE, InlineElement.TYPE, ReplaceElement.TYPE, FragmentElement.TYPE);
    private final FutureParser parserComments = new FutureParser(PATTERN_COMMENTS, Comment.TYPE);
    private Map<String, CharSequence> fragmentsToReplace;
    private final String page;
    private final String name;
    private boolean write = true;
    private boolean found = false;
    private FutureAppendableAdapter futureOut;
    private Executor executor;

    public String getName() {
        return this.name;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public EsiRenderer(Executor executor) {
        this.page = null;
        this.name = null;
        this.executor = executor;
    }

    public EsiRenderer(String page, String name, Executor executor) {
        this.page = page;
        this.name = name;
        this.write = false;
        this.executor = executor;
    }

    public Map<String, CharSequence> getFragmentsToReplace() {
        return this.fragmentsToReplace;
    }

    public void setFragmentsToReplace(Map<String, CharSequence> fragmentsToReplace) {
        this.fragmentsToReplace = fragmentsToReplace;
    }

    @Override
    public void render(HttpEntityEnclosingRequest originalRequest, String content, Writer out) throws IOException, HttpErrorPage {
        if (this.name != null) {
            LOG.debug("Rendering fragment {} in page {}", (Object)this.name, (Object)this.page);
        }
        this.futureOut = new FutureAppendableAdapter(out);
        if (content == null) {
            return;
        }
        try {
            StringBuilderFutureAppendable contentWithoutComments = new StringBuilderFutureAppendable();
            this.parserComments.setHttpRequest(originalRequest);
            this.parserComments.setData(DATA_EXECUTOR, this.executor);
            this.parserComments.parse(content, contentWithoutComments);
            CharSequence contentWithoutCommentsResult = contentWithoutComments.get();
            this.parser.setHttpRequest(originalRequest);
            this.parserComments.setData(DATA_EXECUTOR, this.executor);
            this.parser.parse(contentWithoutCommentsResult, this);
            if (this.name != null && !this.found) {
                throw new HttpErrorPage(502, "Fragment " + this.name + " not found", "Fragment " + this.name + " not found");
            }
            this.futureOut.performAppends();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FutureAppendable enqueueAppend(Future<CharSequence> csq) throws IOException {
        if (this.write) {
            this.futureOut.enqueueAppend(csq);
        }
        return this;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setFound(boolean found) {
        this.found = found;
    }

    @Override
    public FutureAppendable performAppends() throws IOException, HttpErrorPage {
        return this.futureOut.performAppends();
    }

    @Override
    public boolean hasPending() {
        return this.futureOut.hasPending();
    }

    @Override
    public FutureAppendable performAppends(int timeout, TimeUnit unit) throws IOException, HttpErrorPage, TimeoutException {
        return this.futureOut.performAppends(timeout, unit);
    }
}

