/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.esi.AttemptElement;
import org.esigate.esi.ChooseElement;
import org.esigate.esi.Comment;
import org.esigate.esi.CommentElement;
import org.esigate.esi.ExceptElement;
import org.esigate.esi.FragmentElement;
import org.esigate.esi.IncludeElement;
import org.esigate.esi.InlineElement;
import org.esigate.esi.OtherwiseElement;
import org.esigate.esi.RemoveElement;
import org.esigate.esi.ReplaceElement;
import org.esigate.esi.TryElement;
import org.esigate.esi.VarsElement;
import org.esigate.esi.WhenElement;
import org.esigate.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsiRenderer
implements Renderer,
Appendable {
    private static final Logger LOG = LoggerFactory.getLogger(EsiRenderer.class);
    private static final Pattern PATTERN = Pattern.compile("(<esi:\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>)|(</esi:[^>]*>)");
    private static final Pattern PATTERN_COMMENTS = Pattern.compile("(<!--esi)|(-->)");
    private final Parser parser = new Parser(PATTERN, IncludeElement.TYPE, CommentElement.TYPE, RemoveElement.TYPE, VarsElement.TYPE, ChooseElement.TYPE, WhenElement.TYPE, OtherwiseElement.TYPE, TryElement.TYPE, AttemptElement.TYPE, ExceptElement.TYPE, InlineElement.TYPE, ReplaceElement.TYPE, FragmentElement.TYPE);
    private final Parser parserComments = new Parser(PATTERN_COMMENTS, Comment.TYPE);
    private Writer out;
    private Map<String, CharSequence> fragmentsToReplace;
    private final String page;
    private final String name;
    private boolean write = true;
    private boolean found = false;

    public String getName() {
        return this.name;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public EsiRenderer() {
        this.page = null;
        this.name = null;
    }

    public EsiRenderer(String page, String name) {
        this.page = page;
        this.name = name;
        this.write = false;
    }

    public Map<String, CharSequence> getFragmentsToReplace() {
        return this.fragmentsToReplace;
    }

    public void setFragmentsToReplace(Map<String, CharSequence> fragmentsToReplace) {
        this.fragmentsToReplace = fragmentsToReplace;
    }

    @Override
    public void render(HttpEntityEnclosingRequest originalRequest, String content, Writer out) throws IOException, HttpErrorPage {
        if (this.name != null) {
            LOG.debug("Rendering fragment {} in page {}", (Object)this.name, (Object)this.page);
        }
        this.out = out;
        if (content == null) {
            return;
        }
        StringBuilder contentWithoutComments = new StringBuilder();
        this.parserComments.setHttpRequest(originalRequest);
        this.parserComments.parse(content, contentWithoutComments);
        this.parser.setHttpRequest(originalRequest);
        this.parser.parse(contentWithoutComments, this);
        if (this.name != null && !this.found) {
            throw new HttpErrorPage(502, "Fragment " + this.name + " not found", "Fragment " + this.name + " not found");
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (this.write) {
            this.out.append(csq);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.write) {
            this.out.append(c);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (this.write) {
            this.out.append(csq, start, end);
        }
        return this;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setFound(boolean found) {
        this.found = found;
    }
}

