/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;

public class MockMediator
implements ContainerRequestMediator {
    private final HashMap<String, Object> attributes = new HashMap();
    private final ArrayList<Cookie> cookies = new ArrayList();
    private String remoteUser;
    private HttpResponse httpResponse;
    private HttpEntityEnclosingRequest httpRequest;
    private String remoteAddr;

    public MockMediator(String uriString) {
        URI uri = UriUtils.createUri(uriString);
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        this.httpRequest = new BasicHttpEntityEnclosingRequest("GET", uriString);
        if (port == -1 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme)) {
            this.httpRequest.setHeader("Host", host);
        } else {
            this.httpRequest.setHeader("Host", host + ":" + port);
        }
        HttpRequestHelper.setMediator((HttpRequest)this.httpRequest, this);
    }

    public MockMediator() {
        this("http://localhost:8080");
    }

    public Cookie[] getCookies() {
        Cookie[] cookiesArray = new Cookie[this.cookies.size()];
        return this.cookies.toArray(cookiesArray);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Principal getUserPrincipal() {
        throw new RuntimeException("Method not implemented");
    }

    public void sendResponse(HttpResponse response) throws IOException {
        this.httpResponse = new BasicHttpResponse(response.getStatusLine());
        this.httpResponse.setHeaders(response.getAllHeaders());
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ByteArrayEntity copiedEntity = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity));
            if (entity.getContentEncoding() != null) {
                copiedEntity.setContentEncoding(entity.getContentEncoding());
            }
            this.httpResponse.setEntity((HttpEntity)copiedEntity);
        }
    }

    public void setSessionAttribute(String key, Serializable value) {
        this.attributes.put(key, value);
    }

    public Serializable getSessionAttribute(String key) {
        return (Serializable)this.attributes.get(key);
    }

    public InputStream getResourceAsStream(String path) {
        throw new RuntimeException("Method not implemented");
    }

    public HttpEntityEnclosingRequest getHttpRequest() {
        return this.httpRequest;
    }

    public String getSessionId() {
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }
}

