/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.output.WriterOutputStream;

public class ResponseCapturingWrapper
extends HttpServletResponseWrapper {
    private boolean capturing = true;
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;
    private StringWriter writer = new StringWriter();

    public ResponseCapturingWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (!this.capturing) {
            return super.getOutputStream();
        }
        if (this.printWriter != null) {
            throw new IllegalStateException("Writer already obtained");
        }
        if (this.outputStream == null) {
            final WriterOutputStream writerOutputStream = new WriterOutputStream((Writer)this.writer, this.getCharacterEncoding());
            this.outputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    writerOutputStream.write(b);
                }

                public void close() throws IOException {
                    writerOutputStream.close();
                    super.close();
                }
            };
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (!this.capturing) {
            return super.getWriter();
        }
        if (this.outputStream != null) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.writer);
        }
        return this.printWriter;
    }

    public void setContentLength(int len) {
        if (!this.capturing) {
            super.setContentLength(len);
        }
    }

    public void setContentType(String type) {
        if (!type.startsWith("text") && this.outputStream == null && this.printWriter == null) {
            this.capturing = false;
        }
        super.setContentType(type);
    }

    public void setHeader(String name, String value) {
        if (!this.capturing || !name.equalsIgnoreCase("Content-length")) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (!this.capturing || !name.equalsIgnoreCase("Content-length")) {
            super.addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!this.capturing || !name.equalsIgnoreCase("Content-length")) {
            super.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this.capturing || !name.equalsIgnoreCase("Content-length")) {
            super.addIntHeader(name, value);
        }
    }

    public String getResult() {
        return this.writer.toString();
    }
}

